/************************************************************************************************/
/* Stata User File for H216 Data                                                                */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H216.DAT) supplied in this PUF release.                                                     */
/* After entering the Stata interactive environment access the Stata DO-File                    */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H216.DO and is located in the directory                 */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H216.DO                                              */
/* The program below will output the Stata dataset H216.DTA                                     */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-7
  int    PID 8-10
  str    DUPERSID 11-20
  byte   PANEL 21-22
  str    FAMID31 23-24
  str    FAMID42 25-26
  str    FAMID53 27-28
  str    FAMID19 29-30
  str    FAMIDYR 31-32
  str    CPSFAMID 33-34
  byte   FCSZ1231 35-36
  byte   FCRP1231 37-38
  str    RULETR31 39-40
  str    RULETR42 41-42
  str    RULETR53 43-44
  str    RULETR19 45-47
  byte   RUSIZE31 48-49
  byte   RUSIZE42 50-51
  byte   RUSIZE53 52-53
  byte   RUSIZE19 54-55
  byte   RUCLAS31 56-57
  byte   RUCLAS42 58-59
  byte   RUCLAS53 60-61
  byte   RUCLAS19 62-62
  byte   FAMSZE31 63-64
  byte   FAMSZE42 65-66
  byte   FAMSZE53 67-68
  byte   FAMSZE19 69-70
  byte   FMRS1231 71-72
  byte   FAMS1231 73-74
  byte   FAMSZEYR 75-76
  byte   FAMRFPYR 77-77
  byte   REGION31 78-79
  byte   REGION42 80-81
  byte   REGION53 82-83
  byte   REGION19 84-85
  int    REFPRS31 86-88
  int    REFPRS42 89-91
  int    REFPRS53 92-94
  int    REFPRS19 95-97
  byte   RESP31 98-98
  byte   RESP42 99-99
  byte   RESP53 100-100
  byte   RESP19 101-101
  byte   PROXY31 102-103
  byte   PROXY42 104-105
  byte   PROXY53 106-107
  byte   PROXY19 108-108
  byte   INTVLANG 109-110
  byte   BEGRFM31 111-112
  int    BEGRFY31 113-116
  byte   ENDRFM31 117-118
  int    ENDRFY31 119-122
  byte   BEGRFM42 123-124
  int    BEGRFY42 125-128
  byte   ENDRFM42 129-130
  int    ENDRFY42 131-134
  byte   BEGRFM53 135-136
  int    BEGRFY53 137-140
  byte   ENDRFM53 141-142
  int    ENDRFY53 143-146
  byte   ENDRFM19 147-148
  int    ENDRFY19 149-152
  byte   KEYNESS 153-153
  byte   INSCOP31 154-154
  byte   INSCOP42 155-155
  byte   INSCOP53 156-156
  byte   INSCOP19 157-157
  byte   INSC1231 158-158
  byte   INSCOPE 159-159
  byte   ELGRND31 160-160
  byte   ELGRND42 161-161
  byte   ELGRND53 162-162
  byte   ELGRND19 163-163
  byte   PSTATS31 164-165
  byte   PSTATS42 166-167
  byte   PSTATS53 168-169
  str    RURSLT31 170-171
  str    RURSLT42 172-173
  str    RURSLT53 174-175
  byte   AGE31X 176-177
  byte   AGE42X 178-179
  byte   AGE53X 180-181
  byte   AGE19X 182-183
  byte   AGELAST 184-185
  byte   DOBMM 186-187
  int    DOBYY 188-191
  byte   SEX 192-192
  byte   RACEV1X 193-193
  byte   RACEV2X 194-195
  byte   RACEAX 196-196
  byte   RACEBX 197-197
  byte   RACEWX 198-198
  byte   RACETHX 199-199
  byte   HISPANX 200-200
  byte   HISPNCAT 201-201
  byte   MARRY31X 202-203
  byte   MARRY42X 204-205
  byte   MARRY53X 206-207
  byte   MARRY19X 208-209
  int    SPOUID31 210-212
  int    SPOUID42 213-215
  int    SPOUID53 216-218
  int    SPOUID19 219-221
  int    SPOUIN31 222-224
  int    SPOUIN42 225-227
  int    SPOUIN53 228-230
  int    SPOUIN19 231-233
  int    EDUCYR 234-236
  int    HIDEG 237-239
  byte   FTSTU31X 240-241
  byte   FTSTU42X 242-243
  byte   FTSTU53X 244-245
  byte   FTSTU19X 246-247
  byte   ACTDTY31 248-249
  byte   ACTDTY42 250-251
  byte   ACTDTY53 252-253
  byte   REFRL31X 254-255
  byte   REFRL42X 256-257
  byte   REFRL53X 258-259
  byte   REFRL19X 260-261
  int    OTHLGSPK 262-264
  byte   WHTLGSPK 265-266
  byte   HWELLSPK 267-268
  int    BORNUSA 269-271
  byte   YRSINUS 272-273
  int    MOPID31X 274-276
  int    MOPID42X 277-279
  int    MOPID53X 280-282
  int    DAPID31X 283-285
  int    DAPID42X 286-288
  int    DAPID53X 289-291
  byte   RTHLTH31 292-293
  byte   RTHLTH42 294-295
  byte   RTHLTH53 296-297
  byte   MNHLTH31 298-299
  byte   MNHLTH42 300-301
  byte   MNHLTH53 302-303
  int    HIBPDX 304-306
  byte   HIBPAGED 307-308
  byte   BPMLDX 309-310
  int    CHDDX 311-313
  byte   CHDAGED 314-315
  int    ANGIDX 316-318
  byte   ANGIAGED 319-320
  int    MIDX 321-323
  byte   MIAGED 324-325
  int    OHRTDX 326-328
  byte   OHRTAGED 329-330
  byte   OHRTTYPE 331-332
  int    STRKDX 333-335
  byte   STRKAGED 336-337
  int    EMPHDX 338-340
  byte   EMPHAGED 341-342
  byte   CHBRON31 343-344
  int    CHOLDX 345-347
  byte   CHOLAGED 348-349
  int    CANCERDX 350-352
  byte   CABLADDR 353-354
  byte   CABREAST 355-356
  byte   CACERVIX 357-358
  byte   CACOLON 359-360
  byte   CALUNG 361-362
  byte   CALYMPH 363-364
  byte   CAMELANO 365-366
  byte   CAOTHER 367-368
  byte   CAPROSTA 369-370
  byte   CASKINNM 371-372
  byte   CASKINDK 373-374
  byte   CAUTERUS 375-376
  int    DIABDX_M18 377-379
  byte   DIABAGED 380-381
  byte   JTPAIN31_M18 382-383
  int    ARTHDX 384-386
  byte   ARTHTYPE 387-388
  int    ARTHAGED 389-391
  int    ASTHDX 392-394
  byte   ASTHAGED 395-396
  int    ASSTIL31 397-399
  int    ASATAK31 400-402
  byte   ASTHEP31 403-404
  int    ASACUT31 405-407
  byte   ASMRCN31 408-409
  int    ASPREV31 410-412
  byte   ASDALY31 413-414
  int    ASPKFL31 415-417
  byte   ASEVFL31 418-419
  int    ASWNFL31 420-422
  int    ADHDADDX 423-425
  byte   ADHDAGED 426-427
  byte   IADLHP31 428-429
  byte   ADLHLP31 430-431
  byte   AIDHLP31 432-433
  byte   WLKLIM31 434-435
  byte   LFTDIF31 436-437
  byte   STPDIF31 438-439
  byte   WLKDIF31 440-441
  byte   MILDIF31 442-443
  byte   STNDIF31 444-445
  byte   BENDIF31 446-447
  byte   RCHDIF31 448-449
  byte   FNGRDF31 450-451
  byte   ACTLIM31 452-453
  byte   WRKLIM31 454-455
  byte   HSELIM31 456-457
  byte   SCHLIM31 458-459
  byte   UNABLE31 460-461
  byte   SOCLIM31 462-463
  byte   COGLIM31 464-465
  byte   DFHEAR42 466-467
  byte   DFSEE42 468-469
  byte   DFCOG42 470-471
  byte   DFWLKC42 472-473
  byte   DFDRSB42 474-475
  byte   DFERND42 476-477
  int    ANYLMI19 478-480
  int    CHPMED42 481-483
  byte   CHPMHB42 484-485
  byte   CHPMCN42 486-487
  int    CHSERV42 488-490
  byte   CHSRHB42 491-492
  byte   CHSRCN42 493-494
  int    CHLIMI42 495-497
  byte   CHLIHB42 498-499
  byte   CHLICO42 500-501
  int    CHTHER42 502-504
  byte   CHTHHB42 505-506
  byte   CHTHCO42 507-508
  int    CHCOUN42 509-511
  byte   CHEMPB42 512-513
  byte   CSHCN42 514-515
  int    GETTRB42 516-518
  int    MOMPRO42 519-521
  int    DADPRO42 522-524
  int    UNHAP42 525-527
  int    SCHLBH42 528-530
  int    HAVFUN42 531-533
  int    ADUPRO42 534-536
  int    NERVAF42 537-539
  int    SIBPRO42 540-542
  int    KIDPRO42 543-545
  int    SPRPRO42 546-548
  int    SCHPRO42 549-551
  int    HOMEBH42 552-554
  int    CHILCR42 555-557
  byte   CHILWW42 558-559
  int    CHRTCR42 560-562
  byte   CHRTWW42 563-564
  int    CHAPPT42 565-567
  byte   CHEXPL42 568-569
  byte   CHLIST42 570-571
  byte   CHRESP42 572-573
  byte   CHPRTM42 574-575
  byte   CHHECR42 576-577
  int    CHSPEC42_M18 578-580
  byte   CHEYRE42_M18 581-582
  int    LSTETH53 583-585
  int    PHYEXE53 586-588
  int    OFTSMK53 589-591
  byte   SAQELIG 592-592
  int    ADPROX42 593-595
  int    ADGENH42 596-598
  int    ADDAYA42 599-601
  int    ADCLIM42 602-604
  int    ADACLS42 605-607
  int    ADWKLM42 608-610
  int    ADEMLS42 611-613
  int    ADMWCF42 614-616
  int    ADPAIN42 617-619
  int    ADPCFL42 620-622
  int    ADENGY42 623-625
  int    ADPRST42 626-628
  int    ADSOCA42 629-631
  int    ADNERV42 632-634
  int    ADHOPE42 635-637
  int    ADREST42 638-640
  int    ADSAD42 641-643
  int    ADEFRT42 644-646
  int    ADWRTH42 647-649
  int    K6SUM42 650-652
  int    ADINTR42 653-655
  int    ADDPRS42 656-658
  int    PHQ242 659-661
  int    ADINSA42 662-664
  int    ADINSB42 665-667
  int    ADRISK42 668-670
  int    ADOVER42 671-673
  byte   ADILCR42 674-675
  int    ADILWW42 676-678
  byte   ADRTCR42 679-680
  int    ADRTWW42 681-683
  int    ADAPPT42 684-686
  int    ADHECR42 687-689
  byte   ADINST42 690-691
  int    ADEZUN42 692-694
  int    ADTLHW42 695-697
  byte   ADFFRM42 698-699
  int    ADFHLP42 700-702
  int    ADEXPL42 703-705
  int    ADLIST42 706-708
  int    ADRESP42 709-711
  int    ADPRTM42 712-714
  byte   ADSMOK42 715-716
  int    ADNSMK42 717-719
  byte   ADSPCL42 720-721
  int    ADSNSP42 722-724
  double VPCS42 725-730
  double VMCS42 731-736
  byte   VRFLAG42 737-738
  int    ADCMPM42 739-741
  int    ADCMPY42 742-745
  byte   ADLANG42 746-747
  byte   VSAQELIG 748-748
  byte   VACTDY31 749-750
  int    VAPRHT31 751-753
  int    VACOPD31 754-756
  int    VADERM31 757-759
  int    VAGERD31 760-762
  int    VAHRLS31 763-765
  int    VABACK31 766-768
  int    VAJTPN31 769-771
  int    VARTHR31 772-774
  int    VAGOUT31 775-777
  int    VANECK31 778-780
  int    VAFIBR31 781-783
  int    VATMD31 784-786
  int    VAPTSD31 787-789
  int    VALCOH31 790-792
  int    VABIPL31 793-795
  int    VADEPR31 796-798
  int    VAMOOD31 799-801
  int    VAPROS31 802-804
  int    VARHAB31 805-807
  int    VAMNHC31 808-810
  int    VAGCNS31 811-813
  int    VARXMD31 814-816
  int    VACRGV31 817-819
  int    VAMOBL31 820-822
  int    VACOST31 823-825
  int    VARECM31 826-828
  int    VAREP31 829-831
  int    VAWAIT31 832-834
  int    VALOCT31 835-837
  int    VANTWK31 838-840
  int    VANEED31 841-843
  int    VAOUT31 844-846
  int    VAPAST31 847-849
  int    VACOMP31 850-852
  int    VAMREC31 853-855
  int    VAGTRC31 856-858
  int    VACARC31 859-861
  int    VAPROB31 862-864
  int    VACARE31 865-867
  int    VAPACT31 868-870
  int    VAPCPR31 871-873
  int    VAPROV31 874-876
  int    VAPCOT31 877-879
  int    VAPCCO31 880-882
  int    VAPCRC31 883-885
  int    VAPCSN31 886-888
  int    VAPCRF31 889-891
  int    VAPCSO31 892-894
  int    VAPCOU31 895-897
  int    VAPCUN31 898-900
  int    VASPCL31 901-903
  byte   VASPMH31 904-905
  int    VASPOU31 906-908
  int    VASPUN31 909-911
  int    VACMPM31 912-914
  int    VACMPY31 915-918
  int    VAPROX31 919-921
  byte   DCSELIG 922-922
  byte   DSDIA53 923-924
  int    DSA1C53 925-927
  int    DSFT2053 928-930
  int    DSFT1953 931-933
  int    DSFT1853 934-936
  int    DSFB1853 937-939
  int    DSFTNV53 940-942
  int    DSEY2053 943-945
  int    DSEY1953 946-948
  int    DSEY1853 949-951
  int    DSEB1853 952-954
  int    DSEYNV53 955-957
  int    DSCH2053 958-960
  int    DSCH1953 961-963
  int    DSCH1853 964-966
  int    DSCB1853 967-969
  int    DSCHNV53 970-972
  int    DSFL2053 973-975
  int    DSFL1953 976-978
  int    DSFL1853 979-981
  int    DSVB1853 982-984
  int    DSFLNV53 985-987
  int    DSKIDN53 988-990
  int    DSEYPR53 991-993
  int    DSDIET53 994-996
  int    DSMED53 997-999
  int    DSINSU53 1000-1002
  byte   DSCPCP53 1003-1004
  byte   DSCNPC53 1005-1006
  byte   DSCPHN53 1007-1008
  byte   DSCINT53 1009-1010
  byte   DSCGRP53 1011-1012
  int    DSCONF53 1013-1015
  int    DSPRX53 1016-1018
  int    DDNWRK19 1019-1021
  int    OTHDYS19 1022-1024
  int    OTHNDD19 1025-1027
  byte   ACCELI42 1028-1029
  byte   HAVEUS42 1030-1031
  byte   PRACTP42 1032-1033
  byte   YNOUSC42_M18 1034-1035
  byte   PROVTY42_M18 1036-1037
  byte   PLCTYP42 1038-1039
  byte   TMTKUS42 1040-1041
  byte   TYPEPE42 1042-1043
  byte   LOCATN42 1044-1045
  byte   HSPLAP42 1046-1047
  byte   WHITPR42 1048-1049
  byte   BLCKPR42 1050-1051
  byte   ASIANP42 1052-1053
  byte   NATAMP42 1054-1055
  byte   PACISP42 1056-1057
  byte   OTHRCP42 1058-1059
  byte   GENDRP42 1060-1061
  byte   PHNREG42 1062-1063
  byte   OFFHOU42 1064-1065
  byte   AFTHOU42 1066-1067
  byte   TREATM42 1068-1069
  byte   DECIDE42 1070-1071
  byte   EXPLOP42 1072-1073
  byte   PRVSPK42 1074-1075
  byte   DLAYCA42 1076-1077
  byte   AFRDCA42 1078-1079
  byte   DLAYDN42 1080-1081
  byte   AFRDDN42 1082-1083
  byte   DLAYPM42 1084-1085
  byte   AFRDPM42 1086-1087
  int    EMPST31 1088-1090
  int    EMPST42 1091-1093
  int    EMPST53 1094-1096
  int    RNDFLG31 1097-1099
  int    MORJOB31 1100-1102
  int    MORJOB42 1103-1105
  int    MORJOB53 1106-1108
  int    EVRWRK 1109-1111
  double HRWG31X 1112-1117
  double HRWG42X 1118-1123
  double HRWG53X 1124-1129
  byte   HRWGIM31 1130-1130
  byte   HRWGIM42 1131-1131
  byte   HRWGIM53 1132-1132
  int    HRHOW31 1133-1135
  int    HRHOW42 1136-1138
  int    HRHOW53 1139-1141
  int    DIFFWG31 1142-1144
  int    DIFFWG42 1145-1147
  int    DIFFWG53 1148-1150
  double NHRWG31 1151-1156
  double NHRWG42 1157-1162
  double NHRWG53 1163-1168
  int    HOUR31 1169-1171
  int    HOUR42 1172-1174
  int    HOUR53 1175-1177
  int    TEMPJB31 1178-1180
  int    TEMPJB42 1181-1183
  int    TEMPJB53 1184-1186
  int    SSNLJB31 1187-1189
  int    SSNLJB42 1190-1192
  int    SSNLJB53 1193-1195
  int    SELFCM31 1196-1198
  int    SELFCM42 1199-1201
  int    SELFCM53 1202-1204
  int    DISVW31X 1205-1207
  int    DISVW42X 1208-1210
  int    DISVW53X 1211-1213
  int    CHOIC31 1214-1216
  int    CHOIC42 1217-1219
  int    CHOIC53 1220-1222
  int    INDCAT31 1223-1225
  int    INDCAT42 1226-1228
  int    INDCAT53 1229-1231
  int    NUMEMP31 1232-1234
  int    NUMEMP42 1235-1237
  int    NUMEMP53 1238-1240
  int    MORE31 1241-1243
  int    MORE42 1244-1246
  int    MORE53 1247-1249
  int    UNION31 1250-1252
  int    UNION42 1253-1255
  int    UNION53 1256-1258
  int    NWK31 1259-1261
  int    NWK42 1262-1264
  byte   NWK53 1265-1266
  int    CHGJ3142 1267-1269
  int    CHGJ4253 1270-1272
  int    YCHJ3142 1273-1275
  int    YCHJ4253 1276-1278
  int    STJBMM31 1279-1281
  int    STJBYY31 1282-1285
  int    STJBMM42 1286-1288
  int    STJBYY42 1289-1292
  int    STJBMM53 1293-1295
  int    STJBYY53 1296-1299
  int    EVRETIRE 1300-1302
  int    OCCCAT31 1303-1305
  int    OCCCAT42 1306-1308
  int    OCCCAT53 1309-1311
  int    PAYVAC31 1312-1314
  int    PAYVAC42 1315-1317
  int    PAYVAC53 1318-1320
  int    SICPAY31 1321-1323
  int    SICPAY42 1324-1326
  int    SICPAY53 1327-1329
  int    PAYDR31 1330-1332
  int    PAYDR42 1333-1335
  int    PAYDR53 1336-1338
  int    RETPLN31 1339-1341
  int    RETPLN42 1342-1344
  int    RETPLN53 1345-1347
  int    BSNTY31 1348-1350
  int    BSNTY42 1351-1353
  int    BSNTY53 1354-1356
  int    JOBORG31 1357-1359
  int    JOBORG42 1360-1362
  int    JOBORG53 1363-1365
  int    HELD31X 1366-1368
  int    HELD42X 1369-1371
  int    HELD53X 1372-1374
  int    OFFER31X 1375-1377
  int    OFFER42X 1378-1380
  int    OFFER53X 1381-1383
  int    OFREMP31 1384-1386
  int    OFREMP42 1387-1389
  int    OFREMP53 1390-1392
  byte   EMPST31H 1393-1394
  byte   EMPST42H 1395-1396
  byte   EMPST53H 1397-1398
  byte   SLFCM31H 1399-1400
  byte   SLFCM42H 1401-1402
  byte   SLFCM53H 1403-1404
  int    NMEMP31H 1405-1407
  int    NMEMP42H 1408-1410
  int    NMEMP53H 1411-1413
  byte   MORE31H 1414-1415
  byte   MORE42H 1416-1417
  byte   MORE53H 1418-1419
  byte   INDCT31H 1420-1421
  byte   INDCT42H 1422-1423
  byte   INDCT53H 1424-1425
  byte   OCCCT31H 1426-1427
  byte   OCCCT42H 1428-1429
  byte   OCCCT53H 1430-1431
  int    HOUR31H 1432-1434
  int    HOUR42H 1435-1437
  int    HOUR53H 1438-1440
  byte   JBORG31H 1441-1442
  byte   JBORG42H 1443-1444
  byte   JBORG53H 1445-1446
  byte   UNION31H 1447-1448
  byte   UNION42H 1449-1450
  byte   UNION53H 1451-1452
  byte   BSNTY31H 1453-1454
  byte   BSNTY42H 1455-1456
  byte   BSNTY53H 1457-1458
  double HRWG31H 1459-1464
  double HRWG42H 1465-1470
  double HRWG53H 1471-1476
  byte   CMJHLD31 1477-1478
  byte   CMJHLD42 1479-1480
  byte   CMJHLD53 1481-1482
  byte   OFFER31H 1483-1484
  byte   OFFER42H 1485-1486
  byte   OFFER53H 1487-1488
  byte   OFEMP31H 1489-1490
  byte   OFEMP42H 1491-1492
  byte   OFEMP53H 1493-1494
  byte   PYVAC31H 1495-1496
  byte   PYVAC42H 1497-1498
  byte   PYVAC53H 1499-1500
  byte   SCPAY31H 1501-1502
  byte   SCPAY42H 1503-1504
  byte   SCPAY53H 1505-1506
  byte   PAYDR31H 1507-1508
  byte   PAYDR42H 1509-1510
  byte   PAYDR53H 1511-1512
  byte   RTPLN31H 1513-1514
  byte   RTPLN42H 1515-1516
  byte   RTPLN53H 1517-1518
  byte   FILEDR19 1519-1520
  byte   WILFIL19 1521-1522
  byte   FLSTAT19 1523-1524
  byte   FILER19 1525-1526
  byte   JTINRU19 1527-1528
  int    JNTPID19 1529-1531
  byte   TAXFRM19 1532-1533
  byte   FOODST19 1534-1535
  byte   FOODMN19 1536-1537
  int    FOODVL19 1538-1541
  long   TTLP19X 1542-1547
  long   FAMINC19 1548-1553
  byte   POVCAT19 1554-1554
  double POVLEV19 1555-1561
  long   WAGEP19X 1562-1567
  byte   WAGIMP19 1568-1568
  long   BUSNP19X 1569-1574
  byte   BUSIMP19 1575-1575
  int    UNEMP19X 1576-1579
  byte   UNEIMP19 1580-1580
  long   WCMPP19X 1581-1585
  byte   WCPIMP19 1586-1586
  long   INTRP19X 1587-1591
  byte   INTIMP19 1592-1592
  long   DIVDP19X 1593-1597
  byte   DIVIMP19 1598-1598
  long   SALEP19X 1599-1604
  byte   SALIMP19 1605-1605
  long   PENSP19X 1606-1611
  byte   PENIMP19 1612-1612
  long   SSECP19X 1613-1617
  byte   SSCIMP19 1618-1618
  long   TRSTP19X 1619-1624
  byte   TRTIMP19 1625-1625
  long   VETSP19X 1626-1630
  byte   VETIMP19 1631-1631
  long   IRASP19X 1632-1637
  byte   IRAIMP19 1638-1638
  long   ALIMP19X 1639-1643
  byte   ALIIMP19 1644-1644
  long   CHLDP19X 1645-1649
  byte   CHLIMP19 1650-1650
  long   CASHP19X 1651-1655
  byte   CSHIMP19 1656-1656
  long   SSIP19X 1657-1661
  byte   SSIIMP19 1662-1662
  int    PUBP19X 1663-1666
  byte   PUBIMP19 1667-1667
  long   OTHRP19X 1668-1672
  byte   OTHIMP19 1673-1673
  str    HIEUIDX 1674-1682
  byte   TRIJA19X 1683-1684
  byte   TRIFE19X 1685-1686
  byte   TRIMA19X 1687-1688
  byte   TRIAP19X 1689-1690
  byte   TRIMY19X 1691-1692
  byte   TRIJU19X 1693-1694
  byte   TRIJL19X 1695-1696
  byte   TRIAU19X 1697-1698
  byte   TRISE19X 1699-1700
  byte   TRIOC19X 1701-1702
  byte   TRINO19X 1703-1704
  byte   TRIDE19X 1705-1706
  byte   MCRJA19 1707-1708
  byte   MCRFE19 1709-1710
  byte   MCRMA19 1711-1712
  byte   MCRAP19 1713-1714
  byte   MCRMY19 1715-1716
  byte   MCRJU19 1717-1718
  byte   MCRJL19 1719-1720
  byte   MCRAU19 1721-1722
  byte   MCRSE19 1723-1724
  byte   MCROC19 1725-1726
  byte   MCRNO19 1727-1728
  byte   MCRDE19 1729-1730
  byte   MCRJA19X 1731-1732
  byte   MCRFE19X 1733-1734
  byte   MCRMA19X 1735-1736
  byte   MCRAP19X 1737-1738
  byte   MCRMY19X 1739-1740
  byte   MCRJU19X 1741-1742
  byte   MCRJL19X 1743-1744
  byte   MCRAU19X 1745-1746
  byte   MCRSE19X 1747-1748
  byte   MCROC19X 1749-1750
  byte   MCRNO19X 1751-1752
  byte   MCRDE19X 1753-1754
  byte   MCDJA19 1755-1756
  byte   MCDFE19 1757-1758
  byte   MCDMA19 1759-1760
  byte   MCDAP19 1761-1762
  byte   MCDMY19 1763-1764
  byte   MCDJU19 1765-1766
  byte   MCDJL19 1767-1768
  byte   MCDAU19 1769-1770
  byte   MCDSE19 1771-1772
  byte   MCDOC19 1773-1774
  byte   MCDNO19 1775-1776
  byte   MCDDE19 1777-1778
  byte   MCDJA19X 1779-1780
  byte   MCDFE19X 1781-1782
  byte   MCDMA19X 1783-1784
  byte   MCDAP19X 1785-1786
  byte   MCDMY19X 1787-1788
  byte   MCDJU19X 1789-1790
  byte   MCDJL19X 1791-1792
  byte   MCDAU19X 1793-1794
  byte   MCDSE19X 1795-1796
  byte   MCDOC19X 1797-1798
  byte   MCDNO19X 1799-1800
  byte   MCDDE19X 1801-1802
  byte   GVAJA19 1803-1804
  byte   GVAFE19 1805-1806
  byte   GVAMA19 1807-1808
  byte   GVAAP19 1809-1810
  byte   GVAMY19 1811-1812
  byte   GVAJU19 1813-1814
  byte   GVAJL19 1815-1816
  byte   GVAAU19 1817-1818
  byte   GVASE19 1819-1820
  byte   GVAOC19 1821-1822
  byte   GVANO19 1823-1824
  byte   GVADE19 1825-1826
  byte   GVBJA19 1827-1828
  byte   GVBFE19 1829-1830
  byte   GVBMA19 1831-1832
  byte   GVBAP19 1833-1834
  byte   GVBMY19 1835-1836
  byte   GVBJU19 1837-1838
  byte   GVBJL19 1839-1840
  byte   GVBAU19 1841-1842
  byte   GVBSE19 1843-1844
  byte   GVBOC19 1845-1846
  byte   GVBNO19 1847-1848
  byte   GVBDE19 1849-1850
  byte   GVCJA19 1851-1852
  byte   GVCFE19 1853-1854
  byte   GVCMA19 1855-1856
  byte   GVCAP19 1857-1858
  byte   GVCMY19 1859-1860
  byte   GVCJU19 1861-1862
  byte   GVCJL19 1863-1864
  byte   GVCAU19 1865-1866
  byte   GVCSE19 1867-1868
  byte   GVCOC19 1869-1870
  byte   GVCNO19 1871-1872
  byte   GVCDE19 1873-1874
  byte   VAPJA19 1875-1876
  byte   VAPFE19 1877-1878
  byte   VAPMA19 1879-1880
  byte   VAPAP19 1881-1882
  byte   VAPMY19 1883-1884
  byte   VAPJU19 1885-1886
  byte   VAPJL19 1887-1888
  byte   VAPAU19 1889-1890
  byte   VAPSE19 1891-1892
  byte   VAPOC19 1893-1894
  byte   VAPNO19 1895-1896
  byte   VAPDE19 1897-1898
  byte   IHSJA19 1899-1900
  byte   IHSFE19 1901-1902
  byte   IHSMA19 1903-1904
  byte   IHSAP19 1905-1906
  byte   IHSMY19 1907-1908
  byte   IHSJU19 1909-1910
  byte   IHSJL19 1911-1912
  byte   IHSAU19 1913-1914
  byte   IHSSE19 1915-1916
  byte   IHSOC19 1917-1918
  byte   IHSNO19 1919-1920
  byte   IHSDE19 1921-1922
  byte   PUBJA19X 1923-1924
  byte   PUBFE19X 1925-1926
  byte   PUBMA19X 1927-1928
  byte   PUBAP19X 1929-1930
  byte   PUBMY19X 1931-1932
  byte   PUBJU19X 1933-1934
  byte   PUBJL19X 1935-1936
  byte   PUBAU19X 1937-1938
  byte   PUBSE19X 1939-1940
  byte   PUBOC19X 1941-1942
  byte   PUBNO19X 1943-1944
  byte   PUBDE19X 1945-1946
  byte   PEGJA19 1947-1948
  byte   PEGFE19 1949-1950
  byte   PEGMA19 1951-1952
  byte   PEGAP19 1953-1954
  byte   PEGMY19 1955-1956
  byte   PEGJU19 1957-1958
  byte   PEGJL19 1959-1960
  byte   PEGAU19 1961-1962
  byte   PEGSE19 1963-1964
  byte   PEGOC19 1965-1966
  byte   PEGNO19 1967-1968
  byte   PEGDE19 1969-1970
  byte   PDKJA19 1971-1972
  byte   PDKFE19 1973-1974
  byte   PDKMA19 1975-1976
  byte   PDKAP19 1977-1978
  byte   PDKMY19 1979-1980
  byte   PDKJU19 1981-1982
  byte   PDKJL19 1983-1984
  byte   PDKAU19 1985-1986
  byte   PDKSE19 1987-1988
  byte   PDKOC19 1989-1990
  byte   PDKNO19 1991-1992
  byte   PDKDE19 1993-1994
  byte   PNGJA19 1995-1996
  byte   PNGFE19 1997-1998
  byte   PNGMA19 1999-2000
  byte   PNGAP19 2001-2002
  byte   PNGMY19 2003-2004
  byte   PNGJU19 2005-2006
  byte   PNGJL19 2007-2008
  byte   PNGAU19 2009-2010
  byte   PNGSE19 2011-2012
  byte   PNGOC19 2013-2014
  byte   PNGNO19 2015-2016
  byte   PNGDE19 2017-2018
  byte   POGJA19 2019-2020
  byte   POGFE19 2021-2022
  byte   POGMA19 2023-2024
  byte   POGAP19 2025-2026
  byte   POGMY19 2027-2028
  byte   POGJU19 2029-2030
  byte   POGJL19 2031-2032
  byte   POGAU19 2033-2034
  byte   POGSE19 2035-2036
  byte   POGOC19 2037-2038
  byte   POGNO19 2039-2040
  byte   POGDE19 2041-2042
  byte   POEJA19 2043-2044
  byte   POEFE19 2045-2046
  byte   POEMA19 2047-2048
  byte   POEAP19 2049-2050
  byte   POEMY19 2051-2052
  byte   POEJU19 2053-2054
  byte   POEJL19 2055-2056
  byte   POEAU19 2057-2058
  byte   POESE19 2059-2060
  byte   POEOC19 2061-2062
  byte   POENO19 2063-2064
  byte   POEDE19 2065-2066
  byte   PNEJA19 2067-2068
  byte   PNEFE19 2069-2070
  byte   PNEMA19 2071-2072
  byte   PNEAP19 2073-2074
  byte   PNEMY19 2075-2076
  byte   PNEJU19 2077-2078
  byte   PNEJL19 2079-2080
  byte   PNEAU19 2081-2082
  byte   PNESE19 2083-2084
  byte   PNEOC19 2085-2086
  byte   PNENO19 2087-2088
  byte   PNEDE19 2089-2090
  byte   PRXJA19 2091-2092
  byte   PRXFE19 2093-2094
  byte   PRXMA19 2095-2096
  byte   PRXAP19 2097-2098
  byte   PRXMY19 2099-2100
  byte   PRXJU19 2101-2102
  byte   PRXJL19 2103-2104
  byte   PRXAU19 2105-2106
  byte   PRXSE19 2107-2108
  byte   PRXOC19 2109-2110
  byte   PRXNO19 2111-2112
  byte   PRXDE19 2113-2114
  byte   PRIJA19 2115-2116
  byte   PRIFE19 2117-2118
  byte   PRIMA19 2119-2120
  byte   PRIAP19 2121-2122
  byte   PRIMY19 2123-2124
  byte   PRIJU19 2125-2126
  byte   PRIJL19 2127-2128
  byte   PRIAU19 2129-2130
  byte   PRISE19 2131-2132
  byte   PRIOC19 2133-2134
  byte   PRINO19 2135-2136
  byte   PRIDE19 2137-2138
  byte   HPEJA19 2139-2140
  byte   HPEFE19 2141-2142
  byte   HPEMA19 2143-2144
  byte   HPEAP19 2145-2146
  byte   HPEMY19 2147-2148
  byte   HPEJU19 2149-2150
  byte   HPEJL19 2151-2152
  byte   HPEAU19 2153-2154
  byte   HPESE19 2155-2156
  byte   HPEOC19 2157-2158
  byte   HPENO19 2159-2160
  byte   HPEDE19 2161-2162
  byte   HPDJA19 2163-2164
  byte   HPDFE19 2165-2166
  byte   HPDMA19 2167-2168
  byte   HPDAP19 2169-2170
  byte   HPDMY19 2171-2172
  byte   HPDJU19 2173-2174
  byte   HPDJL19 2175-2176
  byte   HPDAU19 2177-2178
  byte   HPDSE19 2179-2180
  byte   HPDOC19 2181-2182
  byte   HPDNO19 2183-2184
  byte   HPDDE19 2185-2186
  byte   HPNJA19 2187-2188
  byte   HPNFE19 2189-2190
  byte   HPNMA19 2191-2192
  byte   HPNAP19 2193-2194
  byte   HPNMY19 2195-2196
  byte   HPNJU19 2197-2198
  byte   HPNJL19 2199-2200
  byte   HPNAU19 2201-2202
  byte   HPNSE19 2203-2204
  byte   HPNOC19 2205-2206
  byte   HPNNO19 2207-2208
  byte   HPNDE19 2209-2210
  byte   HPOJA19 2211-2212
  byte   HPOFE19 2213-2214
  byte   HPOMA19 2215-2216
  byte   HPOAP19 2217-2218
  byte   HPOMY19 2219-2220
  byte   HPOJU19 2221-2222
  byte   HPOJL19 2223-2224
  byte   HPOAU19 2225-2226
  byte   HPOSE19 2227-2228
  byte   HPOOC19 2229-2230
  byte   HPONO19 2231-2232
  byte   HPODE19 2233-2234
  byte   HPXJA19 2235-2236
  byte   HPXFE19 2237-2238
  byte   HPXMA19 2239-2240
  byte   HPXAP19 2241-2242
  byte   HPXMY19 2243-2244
  byte   HPXJU19 2245-2246
  byte   HPXJL19 2247-2248
  byte   HPXAU19 2249-2250
  byte   HPXSE19 2251-2252
  byte   HPXOC19 2253-2254
  byte   HPXNO19 2255-2256
  byte   HPXDE19 2257-2258
  byte   HPRJA19 2259-2260
  byte   HPRFE19 2261-2262
  byte   HPRMA19 2263-2264
  byte   HPRAP19 2265-2266
  byte   HPRMY19 2267-2268
  byte   HPRJU19 2269-2270
  byte   HPRJL19 2271-2272
  byte   HPRAU19 2273-2274
  byte   HPRSE19 2275-2276
  byte   HPROC19 2277-2278
  byte   HPRNO19 2279-2280
  byte   HPRDE19 2281-2282
  byte   INSJA19X 2283-2284
  byte   INSFE19X 2285-2286
  byte   INSMA19X 2287-2288
  byte   INSAP19X 2289-2290
  byte   INSMY19X 2291-2292
  byte   INSJU19X 2293-2294
  byte   INSJL19X 2295-2296
  byte   INSAU19X 2297-2298
  byte   INSSE19X 2299-2300
  byte   INSOC19X 2301-2302
  byte   INSNO19X 2303-2304
  byte   INSDE19X 2305-2306
  byte   PRVEV19 2307-2307
  byte   TRIEV19 2308-2308
  byte   MCREV19 2309-2309
  byte   MCDEV19 2310-2310
  byte   VAEV19 2311-2311
  byte   GVAEV19 2312-2312
  byte   GVBEV19 2313-2313
  byte   GVCEV19 2314-2314
  byte   UNINS19 2315-2315
  byte   INSCOV19 2316-2316
  byte   INSURC19 2317-2317
  byte   TRIST31X 2318-2319
  byte   TRIST42X 2320-2321
  byte   TRIST19X 2322-2323
  byte   TRIPR31X 2324-2325
  byte   TRIPR42X 2326-2327
  byte   TRIPR19X 2328-2329
  byte   TRIEX31X 2330-2331
  byte   TRIEX42X 2332-2333
  byte   TRIEX19X 2334-2335
  byte   TRILI31X 2336-2337
  byte   TRILI42X 2338-2339
  byte   TRILI19X 2340-2341
  byte   TRICH31X 2342-2343
  byte   TRICH42X 2344-2345
  byte   TRICH19X 2346-2347
  int    MCRPD31 2348-2350
  int    MCRPD42 2351-2353
  int    MCRPD19 2354-2356
  int    MCRPD31X 2357-2359
  int    MCRPD42X 2360-2362
  int    MCRPD19X 2363-2365
  int    MCRPB31 2366-2368
  int    MCRPB42 2369-2371
  int    MCRPB19 2372-2374
  int    MCRPHO31 2375-2377
  int    MCRPHO42 2378-2380
  int    MCRPHO19 2381-2383
  int    MCDHMO31 2384-2386
  int    MCDHMO42 2387-2389
  int    MCDHMO19 2390-2392
  int    MCDMC31 2393-2395
  int    MCDMC42 2396-2398
  int    MCDMC19 2399-2401
  int    PRVHMO31 2402-2404
  int    PRVHMO42 2405-2407
  int    PRVHMO19 2408-2410
  byte   FSAGT31 2411-2412
  int    HASFSA31 2413-2415
  double PFSAMT31 2416-2422
  byte   PREVCOVR 2423-2424
  byte   MORECOVR 2425-2426
  byte   TRICR31X 2427-2428
  byte   TRICR42X 2429-2430
  byte   TRICR53X 2431-2432
  byte   TRICR19X 2433-2434
  byte   TRIAT31X 2435-2436
  byte   TRIAT42X 2437-2438
  byte   TRIAT53X 2439-2440
  byte   TRIAT19X 2441-2442
  byte   MCAID31 2443-2444
  byte   MCAID42 2445-2446
  byte   MCAID53 2447-2448
  byte   MCAID19 2449-2450
  byte   MCAID31X 2451-2452
  byte   MCAID42X 2453-2454
  byte   MCAID53X 2455-2456
  byte   MCAID19X 2457-2458
  byte   MCARE31 2459-2460
  byte   MCARE42 2461-2462
  byte   MCARE53 2463-2464
  byte   MCARE19 2465-2466
  byte   MCARE31X 2467-2468
  byte   MCARE42X 2469-2470
  byte   MCARE53X 2471-2472
  byte   MCARE19X 2473-2474
  byte   MCDAT31X 2475-2476
  byte   MCDAT42X 2477-2478
  byte   MCDAT53X 2479-2480
  byte   MCDAT19X 2481-2482
  byte   GOVTA31 2483-2484
  byte   GOVTA42 2485-2486
  byte   GOVTA53 2487-2488
  byte   GOVTA19 2489-2490
  byte   GOVAAT31 2491-2492
  byte   GOVAAT42 2493-2494
  byte   GOVAAT53 2495-2496
  byte   GOVAAT19 2497-2498
  byte   GOVTB31 2499-2500
  byte   GOVTB42 2501-2502
  byte   GOVTB53 2503-2504
  byte   GOVTB19 2505-2506
  byte   GOVBAT31 2507-2508
  byte   GOVBAT42 2509-2510
  byte   GOVBAT53 2511-2512
  byte   GOVBAT19 2513-2514
  byte   GOVTC31 2515-2516
  byte   GOVTC42 2517-2518
  byte   GOVTC53 2519-2520
  byte   GOVTC19 2521-2522
  byte   GOVCAT31 2523-2524
  byte   GOVCAT42 2525-2526
  byte   GOVCAT53 2527-2528
  byte   GOVCAT19 2529-2530
  byte   VAPROG31 2531-2532
  byte   VAPROG42 2533-2534
  byte   VAPROG53 2535-2536
  byte   VAPROG19 2537-2538
  byte   VAPRAT31 2539-2540
  byte   VAPRAT42 2541-2542
  byte   VAPRAT53 2543-2544
  byte   VAPRAT19 2545-2546
  byte   IHS31 2547-2548
  byte   IHS42 2549-2550
  byte   IHS53 2551-2552
  byte   IHS19 2553-2554
  byte   IHSAT31 2555-2556
  byte   IHSAT42 2557-2558
  byte   IHSAT53 2559-2560
  byte   IHSAT19 2561-2562
  byte   PRIDK31 2563-2564
  byte   PRIDK42 2565-2566
  byte   PRIDK53 2567-2568
  byte   PRIDK19 2569-2570
  byte   PRIEU31 2571-2572
  byte   PRIEU42 2573-2574
  byte   PRIEU53 2575-2576
  byte   PRIEU19 2577-2578
  byte   PRING31 2579-2580
  byte   PRING42 2581-2582
  byte   PRING53 2583-2584
  byte   PRING19 2585-2586
  byte   PRIOG31 2587-2588
  byte   PRIOG42 2589-2590
  byte   PRIOG53 2591-2592
  byte   PRIOG19 2593-2594
  byte   PRINEO31 2595-2596
  byte   PRINEO42 2597-2598
  byte   PRINEO53 2599-2600
  byte   PRINEO19 2601-2602
  byte   PRIEUO31 2603-2604
  byte   PRIEUO42 2605-2606
  byte   PRIEUO53 2607-2608
  byte   PRIEUO19 2609-2610
  byte   PRSTX31 2611-2612
  byte   PRSTX42 2613-2614
  byte   PRSTX53 2615-2616
  byte   PRSTX19 2617-2618
  byte   PRIV31 2619-2620
  byte   PRIV42 2621-2622
  byte   PRIV53 2623-2624
  byte   PRIV19 2625-2626
  byte   PRIVAT31 2627-2628
  byte   PRIVAT42 2629-2630
  byte   PRIVAT53 2631-2632
  byte   PRIVAT19 2633-2634
  byte   PUB31X 2635-2636
  byte   PUB42X 2637-2638
  byte   PUB53X 2639-2640
  byte   PUB19X 2641-2642
  byte   PUBAT31X 2643-2644
  byte   PUBAT42X 2645-2646
  byte   PUBAT53X 2647-2648
  byte   PUBAT19X 2649-2650
  byte   VERFLG31 2651-2652
  byte   VERFLG42 2653-2654
  byte   VERFLG19 2655-2656
  byte   INS31X 2657-2658
  byte   INS42X 2659-2660
  byte   INS53X 2661-2662
  byte   INS19X 2663-2664
  byte   INSAT31X 2665-2666
  byte   INSAT42X 2667-2668
  byte   INSAT53X 2669-2670
  byte   INSAT19X 2671-2672
  byte   DENTIN31 2673-2674
  byte   DENTIN42 2675-2676
  byte   DENTIN53 2677-2678
  byte   DNTINS31 2679-2680
  byte   DNTINS19 2681-2682
  byte   PMEDIN31 2683-2684
  byte   PMEDIN42 2685-2686
  byte   PMEDIN53 2687-2688
  byte   PMDINS31 2689-2690
  byte   PMDINS19 2691-2692
  byte   PROBPY42 2693-2694
  byte   CRFMPY42 2695-2696
  byte   PYUNBL42 2697-2698
  byte   PMEDUP31 2699-2700
  byte   PMEDUP42 2701-2702
  byte   PMEDUP53 2703-2704
  int    PMEDPY31 2705-2707
  int    PMEDPY42 2708-2710
  int    PMEDPY53 2711-2713
  long   TOTTCH19 2714-2720
  long   TOTEXP19 2721-2726
  long   TOTSLF19 2727-2732
  long   TOTMCR19 2733-2738
  long   TOTMCD19 2739-2744
  long   TOTPRV19 2745-2750
  long   TOTVA19 2751-2756
  long   TOTTRI19 2757-2761
  long   TOTOFD19 2762-2766
  long   TOTSTL19 2767-2772
  long   TOTWCP19 2773-2777
  long   TOTOSR19 2778-2783
  long   TOTPTR19 2784-2789
  long   TOTOTH19 2790-2795
  int    OBTOTV19 2796-2798
  long   OBVTCH19 2799-2804
  long   OBVEXP19 2805-2810
  long   OBVSLF19 2811-2816
  long   OBVMCR19 2817-2821
  long   OBVMCD19 2822-2826
  long   OBVPRV19 2827-2832
  long   OBVVA19 2833-2837
  long   OBVTRI19 2838-2842
  long   OBVOFD19 2843-2847
  long   OBVSTL19 2848-2852
  long   OBVWCP19 2853-2857
  long   OBVOSR19 2858-2863
  long   OBVPTR19 2864-2869
  long   OBVOTH19 2870-2875
  int    OBDRV19 2876-2878
  long   OBDTCH19 2879-2884
  long   OBDEXP19 2885-2890
  long   OBDSLF19 2891-2896
  long   OBDMCR19 2897-2901
  long   OBDMCD19 2902-2906
  long   OBDPRV19 2907-2912
  long   OBDVA19 2913-2917
  long   OBDTRI19 2918-2922
  long   OBDOFD19 2923-2927
  long   OBDSTL19 2928-2932
  long   OBDWCP19 2933-2937
  long   OBDOSR19 2938-2943
  long   OBDPTR19 2944-2949
  long   OBDOTH19 2950-2955
  int    OPTOTV19 2956-2958
  long   OPTTCH19 2959-2965
  long   OPTEXP19 2966-2971
  long   OPTSLF19 2972-2976
  long   OPTMCR19 2977-2982
  long   OPTMCD19 2983-2987
  long   OPTPRV19 2988-2993
  long   OPTVA19 2994-2998
  long   OPTTRI19 2999-3003
  int    OPTOFD19 3004-3007
  long   OPTSTL19 3008-3013
  long   OPTWCP19 3014-3018
  long   OPTOSR19 3019-3023
  long   OPTPTR19 3024-3029
  long   OPTOTH19 3030-3035
  long   OPFTCH19 3036-3042
  long   OPFEXP19 3043-3048
  long   OPFSLF19 3049-3053
  long   OPFMCR19 3054-3059
  long   OPFMCD19 3060-3064
  long   OPFPRV19 3065-3070
  long   OPFVA19 3071-3075
  long   OPFTRI19 3076-3080
  int    OPFOFD19 3081-3084
  long   OPFSTL19 3085-3090
  long   OPFWCP19 3091-3095
  long   OPFOSR19 3096-3100
  long   OPFPTR19 3101-3106
  long   OPFOTH19 3107-3112
  long   OPDEXP19 3113-3117
  long   OPDTCH19 3118-3123
  long   OPDSLF19 3124-3128
  long   OPDMCR19 3129-3133
  long   OPDMCD19 3134-3138
  long   OPDPRV19 3139-3143
  int    OPDVA19 3144-3147
  int    OPDTRI19 3148-3151
  byte   OPDOFD19 3152-3152
  int    OPDSTL19 3153-3156
  int    OPDWCP19 3157-3160
  long   OPDOSR19 3161-3165
  long   OPDPTR19 3166-3170
  long   OPDOTH19 3171-3175
  int    OPDRV19 3176-3178
  long   OPVTCH19 3179-3185
  long   OPVEXP19 3186-3191
  long   OPVSLF19 3192-3196
  long   OPVMCR19 3197-3202
  long   OPVMCD19 3203-3207
  long   OPVPRV19 3208-3213
  long   OPVVA19 3214-3218
  long   OPVTRI19 3219-3223
  int    OPVOFD19 3224-3227
  long   OPVSTL19 3228-3233
  long   OPVWCP19 3234-3238
  long   OPVOSR19 3239-3243
  long   OPVPTR19 3244-3249
  long   OPVOTH19 3250-3255
  long   OPSEXP19 3256-3260
  long   OPSTCH19 3261-3266
  int    OPSSLF19 3267-3270
  long   OPSMCR19 3271-3275
  int    OPSMCD19 3276-3279
  long   OPSPRV19 3280-3284
  int    OPSVA19 3285-3287
  int    OPSTRI19 3288-3291
  byte   OPSOFD19 3292-3292
  int    OPSSTL19 3293-3296
  int    OPSWCP19 3297-3300
  long   OPSOSR19 3301-3305
  long   OPSPTR19 3306-3310
  long   OPSOTH19 3311-3315
  byte   ERTOT19 3316-3317
  long   ERTTCH19 3318-3323
  long   ERTEXP19 3324-3328
  long   ERTSLF19 3329-3333
  long   ERTMCR19 3334-3338
  long   ERTMCD19 3339-3343
  long   ERTPRV19 3344-3348
  long   ERTVA19 3349-3353
  long   ERTTRI19 3354-3358
  int    ERTOFD19 3359-3362
  long   ERTSTL19 3363-3367
  long   ERTWCP19 3368-3372
  long   ERTOSR19 3373-3377
  long   ERTPTR19 3378-3382
  long   ERTOTH19 3383-3387
  long   ERFTCH19 3388-3393
  long   ERFEXP19 3394-3398
  long   ERFSLF19 3399-3403
  long   ERFMCR19 3404-3408
  long   ERFMCD19 3409-3413
  long   ERFPRV19 3414-3418
  long   ERFVA19 3419-3423
  long   ERFTRI19 3424-3428
  int    ERFOFD19 3429-3432
  long   ERFSTL19 3433-3437
  long   ERFWCP19 3438-3442
  long   ERFOSR19 3443-3447
  long   ERFPTR19 3448-3452
  long   ERFOTH19 3453-3457
  int    ERDEXP19 3458-3461
  long   ERDTCH19 3462-3466
  int    ERDSLF19 3467-3470
  int    ERDMCR19 3471-3474
  int    ERDMCD19 3475-3478
  int    ERDPRV19 3479-3482
  int    ERDVA19 3483-3486
  int    ERDTRI19 3487-3490
  byte   ERDOFD19 3491-3491
  int    ERDSTL19 3492-3494
  int    ERDWCP19 3495-3498
  int    ERDOSR19 3499-3502
  int    ERDPTR19 3503-3506
  int    ERDOTH19 3507-3510
  byte   IPDIS19 3511-3511
  long   IPTEXP19 3512-3517
  long   IPTTCH19 3518-3524
  long   IPTSLF19 3525-3529
  long   IPTMCR19 3530-3535
  long   IPTMCD19 3536-3541
  long   IPTPRV19 3542-3547
  long   IPTVA19 3548-3553
  long   IPTTRI19 3554-3558
  long   IPTOFD19 3559-3563
  long   IPTSTL19 3564-3568
  long   IPTWCP19 3569-3573
  long   IPTOSR19 3574-3578
  long   IPTPTR19 3579-3584
  long   IPTOTH19 3585-3589
  long   IPFEXP19 3590-3595
  long   IPFTCH19 3596-3602
  long   IPFSLF19 3603-3607
  long   IPFMCR19 3608-3613
  long   IPFMCD19 3614-3619
  long   IPFPRV19 3620-3625
  long   IPFVA19 3626-3631
  long   IPFTRI19 3632-3636
  long   IPFOFD19 3637-3641
  long   IPFSTL19 3642-3646
  long   IPFWCP19 3647-3651
  long   IPFOSR19 3652-3656
  long   IPFPTR19 3657-3662
  long   IPFOTH19 3663-3667
  long   IPDEXP19 3668-3672
  long   IPDTCH19 3673-3677
  int    IPDSLF19 3678-3681
  long   IPDMCR19 3682-3686
  long   IPDMCD19 3687-3691
  long   IPDPRV19 3692-3696
  long   IPDVA19 3697-3701
  int    IPDTRI19 3702-3705
  byte   IPDOFD19 3706-3706
  int    IPDSTL19 3707-3709
  long   IPDWCP19 3710-3714
  int    IPDOSR19 3715-3718
  long   IPDPTR19 3719-3723
  int    IPDOTH19 3724-3727
  int    IPNGTD19 3728-3730
  byte   DVTOT19 3731-3732
  long   DVTTCH19 3733-3737
  long   DVTEXP19 3738-3742
  long   DVTSLF19 3743-3747
  long   DVTMCR19 3748-3752
  long   DVTMCD19 3753-3757
  long   DVTPRV19 3758-3762
  long   DVTVA19 3763-3767
  int    DVTTRI19 3768-3771
  long   DVTOFD19 3772-3776
  int    DVTSTL19 3777-3779
  int    DVTWCP19 3780-3782
  int    DVTOSR19 3783-3786
  long   DVTPTR19 3787-3791
  long   DVTOTH19 3792-3796
  int    HHTOTD19 3797-3799
  int    HHAGD19 3800-3802
  long   HHATCH19 3803-3808
  long   HHAEXP19 3809-3814
  long   HHASLF19 3815-3820
  long   HHAMCR19 3821-3826
  long   HHAMCD19 3827-3832
  long   HHAPRV19 3833-3837
  long   HHAVA19 3838-3842
  long   HHATRI19 3843-3847
  byte   HHAOFD19 3848-3848
  long   HHASTL19 3849-3853
  int    HHAWCP19 3854-3857
  long   HHAOSR19 3858-3862
  long   HHAPTR19 3863-3867
  long   HHAOTH19 3868-3872
  int    HHINDD19 3873-3875
  long   HHNTCH19 3876-3881
  long   HHNEXP19 3882-3887
  long   HHNSLF19 3888-3893
  long   HHNMCD19 3894-3898
  long   HHNMCR19 3899-3903
  long   HHNPRV19 3904-3908
  int    HHNVA19 3909-3912
  int    HHNTRI19 3913-3915
  byte   HHNOFD19 3916-3916
  int    HHNSTL19 3917-3920
  byte   HHNWCP19 3921-3921
  int    HHNOSR19 3922-3925
  long   HHNPTR19 3926-3930
  int    HHNOTH19 3931-3934
  int    HHINFD19 3935-3937
  int    VISEXP19 3938-3941
  long   VISTCH19 3942-3946
  int    VISSLF19 3947-3950
  int    VISMCR19 3951-3954
  int    VISMCD19 3955-3958
  int    VISPRV19 3959-3962
  int    VISVA19 3963-3966
  int    VISTRI19 3967-3969
  int    VISOFD19 3970-3972
  int    VISSTL19 3973-3975
  int    VISWCP19 3976-3979
  int    VISOSR19 3980-3982
  int    VISPTR19 3983-3986
  int    VISOTH19 3987-3989
  long   OTHTCH19 3990-3994
  long   OTHEXP19 3995-3999
  long   OTHSLF19 4000-4004
  long   OTHMCR19 4005-4009
  long   OTHMCD19 4010-4014
  long   OTHPRV19 4015-4019
  int    OTHVA19 4020-4023
  long   OTHTRI19 4024-4028
  int    OTHOFD19 4029-4032
  int    OTHSTL19 4033-4036
  int    OTHWCP19 4037-4040
  int    OTHOSR19 4041-4044
  long   OTHPTR19 4045-4049
  int    OTHOTH19 4050-4053
  int    RXTOT19 4054-4056
  long   RXEXP19 4057-4062
  long   RXSLF19 4063-4067
  long   RXMCR19 4068-4073
  long   RXMCD19 4074-4079
  long   RXPRV19 4080-4085
  long   RXVA19 4086-4090
  long   RXTRI19 4091-4095
  long   RXOFD19 4096-4100
  long   RXSTL19 4101-4105
  int    RXWCP19 4106-4109
  int    RXOSR19 4110-4113
  long   RXPTR19 4114-4119
  long   RXOTH19 4120-4124
  double PERWT19F 4125-4136
  double FAMWT19F 4137-4148
  double FAMWT19C 4149-4160
  double SAQWT19F 4161-4173
  double VSAQW19F 4174-4185
  double DIABW19F 4186-4197
  int    VARSTR 4198-4201
  byte   VARPSU 4202-4202
using H216.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "PANEL # + ENCRYPTED DU IDENTIFIER";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID19 "FAMILY ID (STUDENT MERGED IN) - 12/31/19";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR19 "RU LETTER AS OF 12/31/19";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE19 "RU SIZE AS OF 12/31/19";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS19 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/19";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE19 "RU SIZE INCLUDING STUDENT AS OF 12/31/19";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION19 "CENSUS REGION AS OF 12/31/19";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS19 "REFERENCE PERSON AS OF 12/31/19";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP19 "1ST RESPONDENT INDICATOR AS OF 12/31/19";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY19 "WAS RESPONDENT A PROXY AS OF 12/31/19";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM19 "2019 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY19 "2019 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP19 "INSCOPE - R5/3 START THROUGH 12/31/19";
label variable INSC1231 "INSCOPE STATUS ON 12/31/19";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2019";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND19 "ELIGIBILITY STATUS AS OF 12/31/19";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE19X "AGE AS OF 12/31/19 (EDITED/IMPUTED)";
label variable AGELAST "PERSON'S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY19X "MARITAL STATUS-12/31/19 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID19 "SPOUSE ID - 12/31/19";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN19 "MARITAL STATUS W/SPOUSE PRESENT-12/31/19";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU19X "STUDENT STATUS IF AGES 17-23 - 12/31/19";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL19X "RELATION TO REF PERS-12/31/19 (EDIT/IMP)";
label variable OTHLGSPK "SPEAK OTHER LANGUAGE AT HOME";
label variable WHTLGSPK "WHAT LANGUAGE SPOKEN OTHER THAN ENGLISH";
label variable HWELLSPK "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON'S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON'S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON'S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON'S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON'S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON'S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable OHRTTYPE "TYPE OF OTHER HEART DISEASE (>17)";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVICAL (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (NON-HODGKIN S) (>17)";
label variable CAMELANO "CANCER DIAGNOSED - SKIN MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERINE (>17)";
label variable DIABDX_M18 "DIABETES DIAGNOSIS";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31_M18 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA - RD 3/1";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS- RD 3/1";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASACUT31 "USED ACUTE PRESCRIBED INHALER LAST 3 MOS - RD 3/1";
label variable ASMRCN31 "USED >3 ACUTE CANSTRS PRESCRIBED INH LAST 3 MOS - RD 3/1";
label variable ASPREV31 "EVER USED PREV DAILY ASTHMA MEDS - RD 3/1";
label variable ASDALY31 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 3/1";
label variable ASPKFL31 "HAVE PEAK FLOW METER AT HOME - RD 3/1";
label variable ASEVFL31 "EVER USED PEAK FLOW METER - RD 3/1";
label variable ASWNFL31 "WHEN LAST USED PEAK FLOW METER - RD 3/1";
label variable ADHDADDX "ADHD/ADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable ANYLMI19 "ANY LIMITATION IN P23R3,4/P24R1,2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable GETTRB42 "PRBLM GETTING IN TROUBLE (5-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD'S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42_M18 "CAHPS:12MOS: MAKE APPT FOR SPEC (0-17)R4/2";
label variable CHEYRE42_M18 "CAHPS:12MOS: GET APPT FOR SPEC (0-17)R4/2";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable OFTSMK53 "HOW OFTN SMOKE CIGARETTES (>17) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPROX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL VR-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES VR-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS VR-12";
label variable ADACLS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS VR-12";
label variable ADWKLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS VR-12";
label variable ADEMLS42 "SAQ 4WKS: ACCMP LESS B/C MNT PRBS VR-12";
label variable ADMWCF42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS VR-12";
label variable ADPAIN42 "SAQ 4WKS: PAIN LIMITS NORMAL WORK VR-12";
label variable ADPCFL42 "SAQ 4WKS: FELT CALM/PEACEFUL VR-12";
label variable ADENGY42 "SAQ 4WKS: HAD A LOT OF ENERGY VR-12";
label variable ADPRST42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR VR-12";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV VR-12";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVERYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADSPCL42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSNSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable VPCS42 "SAQ:PHY COMPONENT SUMMRY VR-12 IMPUTED";
label variable VMCS42 "SAQ:MNT COMPONENT SUMMRY VR-12 IMPUTED";
label variable VRFLAG42 "SAQ: VPCS42/VMCS42 IMPUTATION FLAG VR-12";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable VSAQELIG "ELIGIBILITY STATUS FOR VSAQ";
label variable VACTDY31 "VSAQ: EVER SERVED ON ACTIVE DUTY";
label variable VAPRHT31 "VSAQ: PURPLE HEART RECIPIENT";
label variable VACOPD31 "VSAQ: DIAGNOSED WITH COPD";
label variable VADERM31 "VSAQ: DIAGNOSED WITH DERMATOL CONDITIONS";
label variable VAGERD31 "VSAQ: DIAGNOSED WITH GERD";
label variable VAHRLS31 "VSAQ: DIAGNOSED WITH HEARING LOSS";
label variable VABACK31 "VSAQ: DIAGNOSED WITH BACK PAIN";
label variable VAJTPN31 "VSAQ: EVER DIAGNOSED WITH JOINT PAIN";
label variable VARTHR31 "VSAQ: EVER DIAGNOSED WITH OSTEOARTHRITIS";
label variable VAGOUT31 "VSAQ: EVER DIAGNOSED WITH GOUT";
label variable VANECK31 "VSAQ: EVER DIAGNOSED WITH NECK PAIN";
label variable VAFIBR31 "VSAQ: EVER DIAGNOSED WITH FIBROMYALGIA";
label variable VATMD31 "VSAQ: EVER DIAGNOSED WITH TMD";
label variable VAPTSD31 "VSAQ: EVER DIAGNOSED WITH PTSD";
label variable VALCOH31 "VSAQ: EVER DIAGNOSED WITH ALCOHOL ABUSE";
label variable VABIPL31 "VSAQ: EVR DIAGNOSED WITH BIPOLAR DISORDER";
label variable VADEPR31 "VSAQ: EVER DIAGNOSED WITH DEPRESSION";
label variable VAMOOD31 "VSAQ: EVER DIAGNOSED WITH MOOD DISORDER";
label variable VAPROS31 "VSAQ: RECEIVE PROSTHESIS";
label variable VARHAB31 "VSAQ: RECEIVE REHABILITATION SERVICES";
label variable VAMNHC31 "VSAQ: RECEIVE INDIVIDL MENTAL HLTH CARE";
label variable VAGCNS31 "VSAQ: RECEIVE MENTAL HLTH GRP COUNSELING";
label variable VARXMD31 "VSAQ: RECEIVE PRESCRIPTION MEDICATIONS";
label variable VACRGV31 "VSAQ: RECEIVE CAREGIVER SUPPORT";
label variable VAMOBL31 "VSAQ: RECEIVE ASSISTIVE MOBILITY DEVICE";
label variable VACOST31 "VSAQ: COST OF CARE";
label variable VARECM31 "VSAQ: RECOMMENDATION OF ANOTHER DOCTOR";
label variable VAREP31 "VSAQ:REPUTATION OF DOCTOR PROVIDING CARE";
label variable VAWAIT31 "VSAQ: SHORT WAIT TIME";
label variable VALOCT31 "VSAQ: LOCATION OF DOCTOR PRACTICE";
label variable VANTWK31 "VSAQ: IN NETWORK PROVIDER";
label variable VANEED31 "VSAQ: UNDERSTANDS NEEDS OF VETERANS";
label variable VAOUT31 "VSAQ 12 MOS: VISIT PROVIDER OUTSIDE VA";
label variable VAPAST31 "VSAQ 12MOS:NON-VA PRVDR KNW PST HLTH PROBLEMS";
label variable VACOMP31 "VSAQ 12MOS: NON-VA PRVDR HLTH INFO COMPLETE";
label variable VAMREC31 "VSAQ 12MOS: ASK NON-VA PRVDR FOR MED RECORDS";
label variable VAGTRC31 "VSAQ 12MOS: NON-VA PRVDR GET MED RECORDS";
label variable VACARC31 "VSAQ 12MOS: NON-VA PRVDR AWARE VA SRVCS";
label variable VAPROB31 "VSAQ: PROB NON-VA PRVDR NOT AWAR VA SVCS";
label variable VACARE31 "VSAQ 12MOS: RECVD CARE FROM VA PROVIDER";
label variable VAPACT31 "VSAQ 12MOS: VISIT PACT OR PCP";
label variable VAPCPR31 "VSAQ 12MOS: VA PCP/PACT KNW PST HLTH PROBLEMS";
label variable VAPROV31 "VSAQ 12MOS: SEE VA PROV OTH THN PCP/PACT";
label variable VAPCOT31 "VSAQ 12MOS: VA PCP KNW RSLT OTH VA PRVDR";
label variable VAPCCO31 "VSAQ 12MOS: VA PCP/PACT HLTH INFO COMPLETE";
label variable VAPCRC31 "VSAQ 12MOS: ASK VA PCP/PACT FOR MED RECORDS";
label variable VAPCSN31 "VSAQ 12MOS: VA PCP/PACT GET MED RECORDS";
label variable VAPCRF31 "VSAQ 12MOS: NEED RFRL TO NON-VA PRVDR";
label variable VAPCSO31 "VSAQ 12MOS: GET RFRL TO NON-VA PRVDR";
label variable VAPCOU31 "VSAQ 12MOS:VA PCP/PACT AWARE NON-VA SVCS";
label variable VAPCUN31 "VSAQ: VA PCP/PACT UNAWARE NON-VA SVCS";
label variable VASPCL31 "VSAQ 12MOS: RECEIVE CARE FROM VA SPECLST";
label variable VASPMH31 "VSAQ 12MOS: VA SPCLST HAD MED HISTORY";
label variable VASPOU31 "VSAQ 12MOS: VA SPCLST AWARE NON-VA SVCS";
label variable VASPUN31 "VSAQ 12MOS: VA SPLST UNAWARE NON-VA SVCS";
label variable VACMPM31 "VSAQ: DATE COMPLETED - MONTH";
label variable VACMPY31 "VSAQ: DATE COMPLETED - YEAR";
label variable VAPROX31 "VSAQ: RELATIONSHIP OF PROXY TO VETERAN";
label variable DCSELIG "DCS: ELIGIBILITY STATUS FOR DCS";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2019";
label variable DSFT2053 "DCS: HAD FEET CHECKED DURING 2020";
label variable DSFT1953 "DCS: HAD FEET CHECKED DURING 2019";
label variable DSFT1853 "DCS: HAD FEET CHECKED DURING 2018";
label variable DSFB1853 "DCS: HAD FEET CHECKED BEFORE 2018";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY2053 "DCS: DILATED EYE EXAM IN 2020";
label variable DSEY1953 "DCS: DILATED EYE EXAM IN 2019";
label variable DSEY1853 "DCS: DILATED EYE EXAM IN 2018";
label variable DSEB1853 "DCS: DILATED EYE EXAM BEFORE 2018";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH2053 "DCS: BLOOD CHOLESTEROL CHECKED IN 2020";
label variable DSCH1953 "DCS: BLOOD CHOLESTEROL CHECKED IN 2019";
label variable DSCH1853 "DCS: BLOOD CHOLESTEROL CHECKED IN 2018";
label variable DSCB1853 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2018";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL2053 "DCS: GOT FLU VACCINATION IN 2020";
label variable DSFL1953 "DCS: GOT FLU VACCINATION IN 2019";
label variable DSFL1853 "DCS: GOT FLU VACCINATION IN 2018";
label variable DSVB1853 "DCS: GOT FLU VACCINATION BEFORE 2018";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/ PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK19 "# DAYS MISSED WORK DUE TO ILL/INJ 2019";
label variable OTHDYS19 "MISS ANY WORK DAY TO CARE FOR OTH 2019";
label variable OTHNDD19 "# DAY MISSED WORK TO CARE FOR OTH 2019";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "DOES PERSON HAVE USC PROVIDER-R4/2";
label variable PRACTP42 "PROVIDER OWN/GROUP PRACTICE-R4/2";
label variable YNOUSC42_M18 "MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable PROVTY42_M18 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "IS PROVIDER MALE OR FEMALE-R4/2";
label variable PHNREG42 "HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable DECIDE42 "PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "PROV SPEAKS PERSON'S LANGUAGE-R4/2";
label variable DLAYCA42 "DELAY MED CARE FOR COST-R4/2";
label variable AFRDCA42 "COULD NOT AFFORD MED CARE-R4/2";
label variable DLAYDN42 "DELAY GETTING DENTAL FOR COST-R4/2";
label variable AFRDDN42 "COULD NOT AFFORD DENTAL CARE-R4/2";
label variable DLAYPM42 "DELAY GETTING PMED FOR COST-R4/2";
label variable AFRDPM42 "COULD NOT AFFORD PMED CARE-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/19";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD 3/1 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD 4/2 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD 5/3 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable FILEDR19 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL19 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT19 "PERSON'S FILING STATUS";
label variable FILER19 "PRIMARY OR SECONDARY FILER";
label variable JTINRU19 "JOINT FILER'S MEMBERSHIP IN RU";
label variable JNTPID19 "PID OF SECONDARY FILER";
label variable TAXFRM19 "TAX FORM PERSON WILL FILE";
label variable FOODST19 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN19 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL19 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP19X "PERSON'S TOTAL INCOME";
label variable FAMINC19 "FAMILY'S TOTAL INCOME";
label variable POVCAT19 "FAMILY INC AS % OF POVERTY LINE - CATEGORICAL";
label variable POVLEV19 "FAMILY INC AS % OF POVERTY LINE - CONTINUOUS";
label variable WAGEP19X "PERSON'S WAGE INCOME";
label variable WAGIMP19 "WAGE IMPUTATION FLAG";
label variable BUSNP19X "PERSON'S BUSINESS INCOME";
label variable BUSIMP19 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP19X "PERSON'S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP19 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP19X "PERSON'S WORKERS  COMPENSATION";
label variable WCPIMP19 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP19X "PERSON'S INTEREST INCOME";
label variable INTIMP19 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP19X "PERSON'S DIVIDEND INCOME";
label variable DIVIMP19 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP19X "PERSON'S SALES INCOME";
label variable SALIMP19 "SALES INCOME IMPUTATION FLAG";
label variable PENSP19X "PERSON'S PENSION INCOME";
label variable PENIMP19 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP19X "PERSON'S SOCIAL SECURITY INCOME";
label variable SSCIMP19 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP19X "PERSON'S TRUST/RENT INCOME";
label variable TRTIMP19 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP19X "PERSON'S VETERAN'S INCOME";
label variable VETIMP19 "VETERAN'S INCOME IMPUTATION FLAG";
label variable IRASP19X "PERSON'S IRA INCOME";
label variable IRAIMP19 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP19X "PERSON'S ALIMONY INCOME";
label variable ALIIMP19 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP19X "PERSON'S CHILD SUPPORT";
label variable CHLIMP19 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP19X "PERSON'S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP19 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP19X "PERSON'S SSI";
label variable SSIIMP19 "SSI IMPUTATION FLAG";
label variable PUBP19X "PERSON'S PUBLIC ASSISTANCE";
label variable PUBIMP19 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP19X "PERSON'S OTHER INCOME";
label variable OTHIMP19 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA19X "COVERED BY TRICARE/CHAMPVA IN JAN19 (ED)";
label variable TRIFE19X "COVERED BY TRICARE/CHAMPVA IN FEB19 (ED)";
label variable TRIMA19X "COVERED BY TRICARE/CHAMPVA IN MAR19 (ED)";
label variable TRIAP19X "COVERED BY TRICARE/CHAMPVA IN APR19(ED)";
label variable TRIMY19X "COVERED BY TRICARE/CHAMPVA IN MAY19 (ED)";
label variable TRIJU19X "COVERED BY TRICARE/CHAMPVA IN JUN19 (ED)";
label variable TRIJL19X "COVERED BY TRICARE/CHAMPVA IN JUL19 (ED)";
label variable TRIAU19X "COVERED BY TRICARE/CHAMPVA IN AUG19 (ED)";
label variable TRISE19X "COVERED BY TRICARE/CHAMPVA IN SEP19 (ED)";
label variable TRIOC19X "COVERED BY TRICARE/CHAMPVA IN OCT19 (ED)";
label variable TRINO19X "COVERED BY TRICARE/CHAMPVA IN NOV19 (ED)";
label variable TRIDE19X "COVERED BY TRICARE/CHAMPVA IN DEC19 (ED)";
label variable MCRJA19 "COVERED BY MEDICARE IN JAN19";
label variable MCRFE19 "COVERED BY MEDICARE IN FEB19";
label variable MCRMA19 "COVERED BY MEDICARE IN MAR19";
label variable MCRAP19 "COVERED BY MEDICARE IN APR19";
label variable MCRMY19 "COVERED BY MEDICARE IN MAY19";
label variable MCRJU19 "COVERED BY MEDICARE IN JUN19";
label variable MCRJL19 "COVERED BY MEDICARE IN JUL19";
label variable MCRAU19 "COVERED BY MEDICARE IN AUG19";
label variable MCRSE19 "COVERED BY MEDICARE IN SEP19";
label variable MCROC19 "COVERED BY MEDICARE IN OCT19";
label variable MCRNO19 "COVERED BY MEDICARE IN NOV19";
label variable MCRDE19 "COVERED BY MEDICARE IN DEC19";
label variable MCRJA19X "COVERED BY MEDICARE IN JAN19 (ED)";
label variable MCRFE19X "COVERED BY MEDICARE IN FEB19 (ED)";
label variable MCRMA19X "COVERED BY MEDICARE IN MAR19 (ED)";
label variable MCRAP19X "COVERED BY MEDICARE IN APR19 (ED)";
label variable MCRMY19X "COVERED BY MEDICARE IN MAY19 (ED)";
label variable MCRJU19X "COVERED BY MEDICARE IN JUN19 (ED)";
label variable MCRJL19X "COVERED BY MEDICARE IN JUL19 (ED)";
label variable MCRAU19X "COVERED BY MEDICARE IN AUG19 (ED)";
label variable MCRSE19X "COVERED BY MEDICARE IN SEP19 (ED)";
label variable MCROC19X "COVERED BY MEDICARE IN OCT19 (ED)";
label variable MCRNO19X "COVERED BY MEDICARE IN NOV19 (ED)";
label variable MCRDE19X "COVERED BY MEDICARE IN DEC19 (ED)";
label variable MCDJA19 "COV BY MEDICAID OR SCHIP IN JAN19";
label variable MCDFE19 "COV BY MEDICAID OR SCHIP IN FEB19";
label variable MCDMA19 "COV BY MEDICAID OR SCHIP IN MAR19";
label variable MCDAP19 "COV BY MEDICAID OR SCHIP IN APR19";
label variable MCDMY19 "COV BY MEDICAID OR SCHIP IN MAY19";
label variable MCDJU19 "COV BY MEDICAID OR SCHIP IN JUN19";
label variable MCDJL19 "COV BY MEDICAID OR SCHIP IN JUL19";
label variable MCDAU19 "COV BY MEDICAID OR SCHIP IN AUG19";
label variable MCDSE19 "COV BY MEDICAID OR SCHIP IN SEP19";
label variable MCDOC19 "COV BY MEDICAID OR SCHIP IN OCT19";
label variable MCDNO19 "COV BY MEDICAID OR SCHIP IN NOV19";
label variable MCDDE19 "COV BY MEDICAID OR SCHIP IN DEC19";
label variable MCDJA19X "COV BY MEDICAID OR SCHIP IN JAN19 (ED)";
label variable MCDFE19X "COV BY MEDICAID OR SCHIP IN FEB19 (ED)";
label variable MCDMA19X "COV BY MEDICAID OR SCHIP IN MAR19 (ED)";
label variable MCDAP19X "COV BY MEDICAID OR SCHIP IN APR19 (ED)";
label variable MCDMY19X "COV BY MEDICAID OR SCHIP IN MAY19 (ED)";
label variable MCDJU19X "COV BY MEDICAID OR SCHIP IN JUN19 (ED)";
label variable MCDJL19X "COV BY MEDICAID OR SCHIP IN JUL19 (ED)";
label variable MCDAU19X "COV BY MEDICAID OR SCHIP IN AUG19 (ED)";
label variable MCDSE19X "COV BY MEDICAID OR SCHIP IN SEP19 (ED)";
label variable MCDOC19X "COV BY MEDICAID OR SCHIP IN OCT19 (ED)";
label variable MCDNO19X "COV BY MEDICAID OR SCHIP IN NOV19 (ED)";
label variable MCDDE19X "COV BY MEDICAID OR SCHIP IN DEC19 (ED)";
label variable GVAJA19 "COV BY OTHER PUBLIC COVERAGE IN JAN19";
label variable GVAFE19 "COV BY OTHER PUBLIC COVERAGE IN FEB19";
label variable GVAMA19 "COV BY OTHER PUBLIC COVERAGE IN MAR19";
label variable GVAAP19 "COV BY OTHER PUBLIC COVERAGE IN APR19";
label variable GVAMY19 "COV BY OTHER PUBLIC COVERAGE IN MAY19";
label variable GVAJU19 "COV BY OTHER PUBLIC COVERAGE IN JUN19";
label variable GVAJL19 "COV BY OTHER PUBLIC COVERAGE IN JUL19";
label variable GVAAU19 "COV BY OTHER PUBLIC COVERAGE IN AUG19";
label variable GVASE19 "COV BY OTHER PUBLIC COVERAGE IN SEP19";
label variable GVAOC19 "COV BY OTHER PUBLIC COVERAGE IN OCT19";
label variable GVANO19 "COV BY OTHER PUBLIC COVERAGE IN NOV19";
label variable GVADE19 "COV BY OTHER PUBLIC COVERAGE IN DEC19";
label variable GVBJA19 "COV BY OTHER PUBLIC HMO IN JAN19";
label variable GVBFE19 "COV BY OTHER PUBLIC HMO IN FEB19";
label variable GVBMA19 "COV BY OTHER PUBLIC HMO IN MAR19";
label variable GVBAP19 "COV BY OTHER PUBLIC HMO IN APR19";
label variable GVBMY19 "COV BY OTHER PUBLIC HMO IN MAY19";
label variable GVBJU19 "COV BY OTHER PUBLIC HMO IN JUN19";
label variable GVBJL19 "COV BY OTHER PUBLIC HMO IN JUL19";
label variable GVBAU19 "COV BY OTHER PUBLIC HMO IN AUG19";
label variable GVBSE19 "COV BY OTHER PUBLIC HMO IN SEP19";
label variable GVBOC19 "COV BY OTHER PUBLIC HMO IN OCT19";
label variable GVBNO19 "COV BY OTHER PUBLIC HMO IN NOV19";
label variable GVBDE19 "COV BY OTHER PUBLIC HMO IN DEC19";
label variable GVCJA19 "COV BY OTHER PUBLIC PAYS PREM IN JAN19";
label variable GVCFE19 "COV BY OTHER PUBLIC PAYS PREM IN FEB19";
label variable GVCMA19 "COV BY OTHER PUBLIC PAYS PREM IN MAR19";
label variable GVCAP19 "COV BY OTHER PUBLIC PAYS PREM IN APR19";
label variable GVCMY19 "COV BY OTHER PUBLIC PAYS PREM IN MAY19";
label variable GVCJU19 "COV BY OTHER PUBLIC PAYS PREM IN JUN19";
label variable GVCJL19 "COV BY OTHER PUBLIC PAYS PREM IN JUL19";
label variable GVCAU19 "COV BY OTHER PUBLIC PAYS PREM IN AUG19";
label variable GVCSE19 "COV BY OTHER PUBLIC PAYS PREM IN SEP19";
label variable GVCOC19 "COV BY OTHER PUBLIC PAYS PREM IN OCT19";
label variable GVCNO19 "COV BY OTHER PUBLIC PAYS PREM IN NOV19";
label variable GVCDE19 "COV BY OTHER PUBLIC PAYS PREM IN DEC19";
label variable VAPJA19 "COVERED BY VA IN JAN19";
label variable VAPFE19 "COVERED BY VA IN FEB19";
label variable VAPMA19 "COVERED BY VA IN MAR19";
label variable VAPAP19 "COVERED BY VA IN APR19";
label variable VAPMY19 "COVERED BY VA IN MAY19";
label variable VAPJU19 "COVERED BY VA IN JUN19";
label variable VAPJL19 "COVERED BY VA IN JUL19";
label variable VAPAU19 "COVERED BY VA IN AUG19";
label variable VAPSE19 "COVERED BY VA IN SEP19";
label variable VAPOC19 "COVERED BY VA IN OCT19";
label variable VAPNO19 "COVERED BY VA IN NOV19";
label variable VAPDE19 "COVERED BY VA IN DEC19";
label variable IHSJA19 "COV BY INDIAN HEALTH SERVICE IN JAN19";
label variable IHSFE19 "COV BY INDIAN HEALTH SERVICE IN FEB19";
label variable IHSMA19 "COV BY INDIAN HEALTH SERVICE IN MAR19";
label variable IHSAP19 "COV BY INDIAN HEALTH SERVICE IN APR19";
label variable IHSMY19 "COV BY INDIAN HEALTH SERVICE IN MAY19";
label variable IHSJU19 "COV BY INDIAN HEALTH SERVICE IN JUN19";
label variable IHSJL19 "COV BY INDIAN HEALTH SERVICE IN JUL19";
label variable IHSAU19 "COV BY INDIAN HEALTH SERVICE IN AUG19";
label variable IHSSE19 "COV BY INDIAN HEALTH SERVICE IN SEP19";
label variable IHSOC19 "COV BY INDIAN HEALTH SERVICE IN OCT19";
label variable IHSNO19 "COV BY INDIAN HEALTH SERVICE IN NOV19";
label variable IHSDE19 "COV BY INDIAN HEALTH SERVICE IN DEC19";
label variable PUBJA19X "COVR BY ANY PUBLIC INS IN JAN19";
label variable PUBFE19X "COVR BY ANY PUBLIC INS IN FEB19";
label variable PUBMA19X "COVR BY ANY PUBLIC INS IN MAR19";
label variable PUBAP19X "COVR BY ANY PUBLIC INS IN APR19";
label variable PUBMY19X "COVR BY ANY PUBLIC INS IN MAY19";
label variable PUBJU19X "COVR BY ANY PUBLIC INS IN JUN19";
label variable PUBJL19X "COVR BY ANY PUBLIC INS IN JUL19";
label variable PUBAU19X "COVR BY ANY PUBLIC INS IN AUG19";
label variable PUBSE19X "COVR BY ANY PUBLIC INS IN SEP19";
label variable PUBOC19X "COVR BY ANY PUBLIC INS IN OCT19";
label variable PUBNO19X "COVR BY ANY PUBLIC INS IN NOV19";
label variable PUBDE19X "COVR BY ANY PUBLIC INS IN DEC19";
label variable PEGJA19 "COVERED BY EMPL UNION INS IN JAN19";
label variable PEGFE19 "COVERED BY EMPL UNION INS IN FEB19";
label variable PEGMA19 "COVERED BY EMPL UNION INS IN MAR19";
label variable PEGAP19 "COVERED BY EMPL UNION INS IN APR19";
label variable PEGMY19 "COVERED BY EMPL UNION INS IN MAY19";
label variable PEGJU19 "COVERED BY EMPL UNION INS IN JUN19";
label variable PEGJL19 "COVERED BY EMPL UNION INS IN JUL19";
label variable PEGAU19 "COVERED BY EMPL UNION INS IN AUG19";
label variable PEGSE19 "COVERED BY EMPL UNION INS IN SEP19";
label variable PEGOC19 "COVERED BY EMPL UNION INS IN OCT19";
label variable PEGNO19 "COVERED BY EMPL UNION INS IN NOV19";
label variable PEGDE19 "COVERED BY EMPL UNION INS IN DEC19";
label variable PDKJA19 "COVR BY PRIV INS (SOURCE UNKNWN) JAN19";
label variable PDKFE19 "COVR BY PRIV INS (SOURCE UNKNWN) FEB19";
label variable PDKMA19 "COVR BY PRIV INS (SOURCE UNKNWN) MAR19";
label variable PDKAP19 "COVR BY PRIV INS (SOURCE UNKNWN) APR19";
label variable PDKMY19 "COVR BY PRIV INS (SOURCE UNKNWN) MAY19";
label variable PDKJU19 "COVR BY PRIV INS (SOURCE UNKNWN) JUN19";
label variable PDKJL19 "COVR BY PRIV INS (SOURCE UNKNWN) JUL19";
label variable PDKAU19 "COVR BY PRIV INS (SOURCE UNKNWN) AUG19";
label variable PDKSE19 "COVR BY PRIV INS (SOURCE UNKNWN) SEP19";
label variable PDKOC19 "COVR BY PRIV INS (SOURCE UNKNWN) OCT19";
label variable PDKNO19 "COVR BY PRIV INS (SOURCE UNKNWN) NOV19";
label variable PDKDE19 "COVR BY PRIV INS (SOURCE UNKNWN) DEC19";
label variable PNGJA19 "COVERED BY NONGROUP INS IN JAN19";
label variable PNGFE19 "COVERED BY NONGROUP INS IN FEB19";
label variable PNGMA19 "COVERED BY NONGROUP INS IN MAR19";
label variable PNGAP19 "COVERED BY NONGROUP INS IN APR19";
label variable PNGMY19 "COVERED BY NONGROUP INS IN MAY19";
label variable PNGJU19 "COVERED BY NONGROUP INS IN JUN19";
label variable PNGJL19 "COVERED BY NONGROUP INS IN JUL19";
label variable PNGAU19 "COVERED BY NONGROUP INS IN AUG19";
label variable PNGSE19 "COVERED BY NONGROUP INS IN SEP19";
label variable PNGOC19 "COVERED BY NONGROUP INS IN OCT19";
label variable PNGNO19 "COVERED BY NONGROUP INS IN NOV19";
label variable PNGDE19 "COVERED BY NONGROUP INS IN DEC19";
label variable POGJA19 "COVERED BY OTHER GROUP INS IN JAN19";
label variable POGFE19 "COVERED BY OTHER GROUP INS IN FEB19";
label variable POGMA19 "COVERED BY OTHER GROUP INS IN MAR19";
label variable POGAP19 "COVERED BY OTHER GROUP INS IN APR19";
label variable POGMY19 "COVERED BY OTHER GROUP INS IN MAY19";
label variable POGJU19 "COVERED BY OTHER GROUP INS IN JUN19";
label variable POGJL19 "COVERED BY OTHER GROUP INS IN JUL19";
label variable POGAU19 "COVERED BY OTHER GROUP INS IN AUG19";
label variable POGSE19 "COVERED BY OTHER GROUP INS IN SEP19";
label variable POGOC19 "COVERED BY OTHER GROUP INS IN OCT19";
label variable POGNO19 "COVERED BY OTHER GROUP INS IN NOV19";
label variable POGDE19 "COVERED BY OTHER GROUP INS IN DEC19";
label variable POEJA19 "COV BY ESI, PHOLDER OUTSIDE RU IN JAN19";
label variable POEFE19 "COV BY ESI, PHOLDER OUTSIDE RU IN FEB19";
label variable POEMA19 "COV BY ESI, PHOLDER OUTSIDE RU IN MAR19";
label variable POEAP19 "COV BY ESI, PHOLDER OUTSIDE RU IN APR19";
label variable POEMY19 "COV BY ESI, PHOLDER OUTSIDE RU IN MAY19";
label variable POEJU19 "COV BY ESI, PHOLDER OUTSIDE RU IN JUN19";
label variable POEJL19 "COV BY ESI, PHOLDER OUTSIDE RU IN JUL19";
label variable POEAU19 "COV BY ESI, PHOLDER OUTSIDE RU IN AUG19";
label variable POESE19 "COV BY ESI, PHOLDER OUTSIDE RU IN SEP19";
label variable POEOC19 "COV BY ESI, PHOLDER OUTSIDE RU IN OCT19";
label variable POENO19 "COV BY ESI, PHOLDER OUTSIDE RU IN NOV19";
label variable POEDE19 "COV BY ESI, PHOLDER OUTSIDE RU IN DEC19";
label variable PNEJA19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JAN19";
label variable PNEFE19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN FEB19";
label variable PNEMA19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN MAR19";
label variable PNEAP19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN APR19";
label variable PNEMY19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN MAY19";
label variable PNEJU19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JUN19";
label variable PNEJL19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JUL19";
label variable PNEAU19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN AUG19";
label variable PNESE19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN SEP19";
label variable PNEOC19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN OCT19";
label variable PNENO19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN NOV19";
label variable PNEDE19 "COV BY NON-ESI, PHLDR OUTSIDE RU IN DEC19";
label variable PRXJA19 "COV BY PRIV INS THROUGH EXCHNG IN JAN19";
label variable PRXFE19 "COV BY PRIV INS THROUGH EXCHNG IN FEB19";
label variable PRXMA19 "COV BY PRIV INS THROUGH EXCHNG IN MAR19";
label variable PRXAP19 "COV BY PRIV INS THROUGH EXCHNG IN APR19";
label variable PRXMY19 "COV BY PRIV INS THROUGH EXCHNG IN MAY19";
label variable PRXJU19 "COV BY PRIV INS THROUGH EXCHNG IN JUN19";
label variable PRXJL19 "COV BY PRIV INS THROUGH EXCHNG IN JUL19";
label variable PRXAU19 "COV BY PRIV INS THROUGH EXCHNG IN AUG19";
label variable PRXSE19 "COV BY PRIV INS THROUGH EXCHNG IN SEP19";
label variable PRXOC19 "COV BY PRIV INS THROUGH EXCHNG IN OCT19";
label variable PRXNO19 "COV BY PRIV INS THROUGH EXCHNG IN NOV19";
label variable PRXDE19 "COV BY PRIV INS THROUGH EXCHNG IN DEC19";
label variable PRIJA19 "COVERED BY PRIVATE INS IN JAN19";
label variable PRIFE19 "COVERED BY PRIVATE INS IN FEB19";
label variable PRIMA19 "COVERED BY PRIVATE INS IN MAR19";
label variable PRIAP19 "COVERED BY PRIVATE INS IN APR19";
label variable PRIMY19 "COVERED BY PRIVATE INS IN MAY19";
label variable PRIJU19 "COVERED BY PRIVATE INS IN JUN19";
label variable PRIJL19 "COVERED BY PRIVATE INS IN JUL19";
label variable PRIAU19 "COVERED BY PRIVATE INS IN AUG19";
label variable PRISE19 "COVERED BY PRIVATE INS IN SEP19";
label variable PRIOC19 "COVERED BY PRIVATE INS IN OCT19";
label variable PRINO19 "COVERED BY PRIVATE INS IN NOV19";
label variable PRIDE19 "COVERED BY PRIVATE INS IN DEC19";
label variable HPEJA19 "PHOLDER OF EMPL UNION INS IN JAN19";
label variable HPEFE19 "PHOLDER OF EMPL UNION INS IN FEB19";
label variable HPEMA19 "PHOLDER OF EMPL UNION INS IN MAR19";
label variable HPEAP19 "PHOLDER OF EMPL UNION INS IN APR19";
label variable HPEMY19 "PHOLDER OF EMPL UNION INS IN MAY19";
label variable HPEJU19 "PHOLDER OF EMPL UNION INS IN JUN19";
label variable HPEJL19 "PHOLDER OF EMPL UNION INS IN JUL19";
label variable HPEAU19 "PHOLDER OF EMPL UNION INS IN AUG19";
label variable HPESE19 "PHOLDER OF EMPL UNION INS IN SEP19";
label variable HPEOC19 "PHOLDER OF EMPL UNION INS IN OCT19";
label variable HPENO19 "PHOLDER OF EMPL UNION INS IN NOV19";
label variable HPEDE19 "PHOLDER OF EMPL UNION INS IN DEC19";
label variable HPDJA19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JAN19";
label variable HPDFE19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) FEB19";
label variable HPDMA19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) MAR19";
label variable HPDAP19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) APR19";
label variable HPDMY19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) MAY19";
label variable HPDJU19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JUN19";
label variable HPDJL19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JUL19";
label variable HPDAU19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) AUG19";
label variable HPDSE19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) SEP19";
label variable HPDOC19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) OCT19";
label variable HPDNO19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) NOV19";
label variable HPDDE19 "PHOLDER OF PRIV INS (SOURCE UNKNWN) DEC19";
label variable HPNJA19 "PHOLDER OF NONGROUP INS IN JAN19";
label variable HPNFE19 "PHOLDER OF NONGROUP INS IN FEB19";
label variable HPNMA19 "PHOLDER OF NONGROUP INS IN MAR19";
label variable HPNAP19 "PHOLDER OF NONGROUP INS IN APR19";
label variable HPNMY19 "PHOLDER OF NONGROUP INS IN MAY19";
label variable HPNJU19 "PHOLDER OF NONGROUP INS IN JUN19";
label variable HPNJL19 "PHOLDER OF NONGROUP INS IN JUL19";
label variable HPNAU19 "PHOLDER OF NONGROUP INS IN AUG19";
label variable HPNSE19 "PHOLDER OF NONGROUP INS IN SEP19";
label variable HPNOC19 "PHOLDER OF NONGROUP INS IN OCT19";
label variable HPNNO19 "PHOLDER OF NONGROUP INS IN NOV19";
label variable HPNDE19 "PHOLDER OF NONGROUP INS IN DEC19";
label variable HPOJA19 "PHOLDER OF OTHER GROUP INS IN JAN19";
label variable HPOFE19 "PHOLDER OF OTHER GROUP INS IN FEB19";
label variable HPOMA19 "PHOLDER OF OTHER GROUP INS IN MAR19";
label variable HPOAP19 "PHOLDER OF OTHER GROUP INS IN APR19";
label variable HPOMY19 "PHOLDER OF OTHER GROUP INS IN MAY19";
label variable HPOJU19 "PHOLDER OF OTHER GROUP INS IN JUN19";
label variable HPOJL19 "PHOLDER OF OTHER GROUP INS IN JUL19";
label variable HPOAU19 "PHOLDER OF OTHER GROUP INS IN AUG19";
label variable HPOSE19 "PHOLDER OF OTHER GROUP INS IN SEP19";
label variable HPOOC19 "PHOLDER OF OTHER GROUP INS IN OCT19";
label variable HPONO19 "PHOLDER OF OTHER GROUP INS IN NOV19";
label variable HPODE19 "PHOLDER OF OTHER GROUP INS IN DEC19";
label variable HPXJA19 "PHOLDER OF PRIV INS THROUGH EXCH IN JAN19";
label variable HPXFE19 "PHOLDER OF PRIV INS THROUGH EXCH IN FEB19";
label variable HPXMA19 "PHOLDER OF PRIV INS THROUGH EXCH IN MAR19";
label variable HPXAP19 "PHOLDER OF PRIV INS THROUGH EXCH IN APR19";
label variable HPXMY19 "PHOLDER OF PRIV INS THROUGH EXCH IN MAY19";
label variable HPXJU19 "PHOLDER OF PRIV INS THROUGH EXCH IN JUN19";
label variable HPXJL19 "PHOLDER OF PRIV INS THROUGH EXCH IN JUL19";
label variable HPXAU19 "PHOLDER OF PRIV INS THROUGH EXCH IN AUG19";
label variable HPXSE19 "PHOLDER OF PRIV INS THROUGH EXCH IN SEP19";
label variable HPXOC19 "PHOLDER OF PRIV INS THROUGH EXCH IN OCT19";
label variable HPXNO19 "PHOLDER OF PRIV INS THROUGH EXCH IN NOV19";
label variable HPXDE19 "PHOLDER OF PRIV INS THROUGH EXCH IN DEC19";
label variable HPRJA19 "PHOLDER OF PRIVATE INSURANCE IN JAN19";
label variable HPRFE19 "PHOLDER OF PRIVATE INSURANCE IN FEB19";
label variable HPRMA19 "PHOLDER OF PRIVATE INSURANCE IN MAR19";
label variable HPRAP19 "PHOLDER OF PRIVATE INSURANCE IN APR19";
label variable HPRMY19 "PHOLDER OF PRIVATE INSURANCE IN MAY19";
label variable HPRJU19 "PHOLDER OF PRIVATE INSURANCE IN JUN19";
label variable HPRJL19 "PHOLDER OF PRIVATE INSURANCE IN JUL19";
label variable HPRAU19 "PHOLDER OF PRIVATE INSURANCE IN AUG19";
label variable HPRSE19 "PHOLDER OF PRIVATE INSURANCE IN SEP19";
label variable HPROC19 "PHOLDER OF PRIVATE INSURANCE IN OCT19";
label variable HPRNO19 "PHOLDER OF PRIVATE INSURANCE IN NOV19";
label variable HPRDE19 "PHOLDER OF PRIVATE INSURANCE IN DEC19";
label variable INSJA19X "COVR BY HOSP/MED INS IN JAN19";
label variable INSFE19X "COVR BY HOSP/MED INS IN FEB19";
label variable INSMA19X "COVR BY HOSP/MED INS IN MAR19";
label variable INSAP19X "COVR BY HOSP/MED INS IN APR19";
label variable INSMY19X "COVR BY HOSP/MED INS IN MAY19";
label variable INSJU19X "COVR BY HOSP/MED INS IN JUN19";
label variable INSJL19X "COVR BY HOSP/MED INS IN JUL19";
label variable INSAU19X "COVR BY HOSP/MED INS IN AUG19";
label variable INSSE19X "COVR BY HOSP/MED INS IN SEP19";
label variable INSOC19X "COVR BY HOSP/MED INS IN OCT19";
label variable INSNO19X "COVR BY HOSP/MED INS IN NOV19";
label variable INSDE19X "COVR BY HOSP/MED INS IN DEC19";
label variable PRVEV19 "EVER HAVE PRIVATE INSURANCE DURING 2019";
label variable TRIEV19 "EVER HAVE TRICARE/CHAMPVA DURING 2019";
label variable MCREV19 "EVER HAVE MEDICARE DURING 2019 (ED)";
label variable MCDEV19 "EVER HAVE MCAID/SCHIP DURING 2019 (ED)";
label variable VAEV19 "EVER HAVE VA DURING 2019";
label variable GVAEV19 "EVER HAVE OTHER PUBLIC DURING 2019";
label variable GVBEV19 "EVER HAVE OTHER PUBLIC HMO DURING 2019";
label variable GVCEV19 "EVER HAVE OTH PUB PAYS PREM DURING 2019";
label variable UNINS19 "UNINSURED ALL OF 2019";
label variable INSCOV19 "HEALTH INSURANCE COVERAGE INDICATOR 2019";
label variable INSURC19 "FULL YEAR INSURANCE COVERAGE STATUS 2019";
label variable TRIST31X "COV BY TRICARE STANDARD-ANY TIME IN R3/1";
label variable TRIST42X "COV BY TRICARE STANDARD-ANY TIME IN R4/2";
label variable TRIST19X "CV BY TRICARE STANDARD-R5/3 TIL 12/31/19";
label variable TRIPR31X "COV BY TRICARE PRIME - ANY TIME IN R3/1";
label variable TRIPR42X "COV BY TRICARE PRIME - ANY TIME IN R4/2";
label variable TRIPR19X "COV BY TRICARE PRIME-R5/3 UNTIL 12/31/19";
label variable TRIEX31X "COV BY TRICARE EXTRA - ANY TIME IN R3/1";
label variable TRIEX42X "COV BY TRICARE EXTRA - ANY TIME IN R4/2";
label variable TRIEX19X "COV BY TRICARE EXTRA - R5/3 TIL 12/31/19";
label variable TRILI31X "COV BY TRICARE FOR LIFE-ANY TIME IN R3/1";
label variable TRILI42X "COV BY TRICARE FOR LIFE-ANY TIME IN R4/2";
label variable TRILI19X "CV BY TRICARE FOR LIFE-R5/3 TIL 12/31/19";
label variable TRICH31X "COVERED BY CHAMPVA - ANY TIME IN R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - ANY TIME IN R4/2";
label variable TRICH19X "COVERED BY CHAMPVA - R5/3 UNTIL 12/31/19";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD19 "COV BY MEDICARE PMED BENEFIT - 12/31/19";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD19X "COV BY MCARE PMED BENEFIT-12/31/19 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB19 "COV BY MEDICARE PART B - 12/31/19";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - R4/2";
label variable MCRPHO19 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - 12/31/19";
label variable MCDHMO31 "COV BY MCAID/SCHIP HMO -ANY TIME IN R3/1";
label variable MCDHMO42 "COV BY MCAID/SCHIP HMO -ANY TIME IN R4/2";
label variable MCDHMO19 "COV BY MCAID/SCHIP HMO-R5/3 TIL 12/31/19";
label variable MCDMC31 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R3/1";
label variable MCDMC42 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R4/2";
label variable MCDMC19 "CV MCD/CHIP GTKPR PLN-R5/3 TIL 12/31/19";
label variable PRVHMO31 "COVERED BY PRIVATE HMO-ANY TIME IN R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO-ANY TIME IN R4/2";
label variable PRVHMO19 "COVERED BY PRIVATE HMO-R5/3 TIL 12/31/19";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable PFSAMT31 "PERSON-LEVEL FSA TOTAL AMOUNT - R3/1";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 24 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 24 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR19X "COV BY TRICR/CHAMV - 12/31/19 (ED)";
label variable TRIAT31X "COV TRICARE/CHAMPVA - ANY TIME IN R3/1";
label variable TRIAT42X "COV TRICARE/CHAMPVA - ANY TIME IN R4/2";
label variable TRIAT53X "COV TRICARE/CHAMPVA - ANY TIME IN R5/3";
label variable TRIAT19X "COV TRICARE/CHAMPVA-R5/3 UNTIL 12/31/19";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID19 "COV BY MEDICAID OR SCHIP - 12/31/19";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID19X "COV BY MEDICAID OR SCHIP - 12/31/19 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE19 "COV BY MEDICARE - 12/31/19";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE19X "COV BY MEDICARE - 12/31/19 (ED)";
label variable MCDAT31X "COV MEDICAID OR SCHIP - ANY TIME IN R3/1";
label variable MCDAT42X "COV MEDICAID OR SCHIP - ANY TIME IN R4/2";
label variable MCDAT53X "COV MEDICAID OR SCHIP - ANY TIME IN R5/3";
label variable MCDAT19X "CV MCD/CHIP-ANY TME IN R5/3 TIL 12/31/19";
label variable GOVTA31 "COV BY OTHER PUBLIC COV - R3/1 INT DT";
label variable GOVTA42 "COV BY OTHER PUBLIC COV - R4/2 INT DT";
label variable GOVTA53 "COV BY OTHER PUBLIC COV 12-31/R3 INT DT";
label variable GOVTA19 "COV BY OTHER PUBLIC COV - 12/31/19";
label variable GOVAAT31 "COV BY OTHER PUBLIC-ANY TIME IN R3/1";
label variable GOVAAT42 "COV BY OTHER PUBLIC-ANY TIME IN R4/2";
label variable GOVAAT53 "COV BY OTHER PUBLIC-ANY TIME IN R5/3";
label variable GOVAAT19 "CV OTH PUB-ANY TME IN R5/3 TIL 12/31/19";
label variable GOVTB31 "COV BY OTH PUB HMO - R3/1 INT DT";
label variable GOVTB42 "COV BY OTH PUB HMO - R4/2 INT DT";
label variable GOVTB53 "COV BY OTH PUB HMO 12-31/R3 INT DT";
label variable GOVTB19 "COV BY OTH PUB HMO - 12/31/19";
label variable GOVBAT31 "COV BY OTH PUB HMO-ANY TIME IN R3/1";
label variable GOVBAT42 "COV BY OTH PUB HMO-ANY TIME IN R4/2";
label variable GOVBAT53 "COV BY OTH PUB HMO-ANY TIME IN R5/3";
label variable GOVBAT19 "COV OTH PB HMO-ANY TM R5/3 TIL 12/31/19";
label variable GOVTC31 "COV BY OTH PUB PAYS PREM - R3/1 INT DT";
label variable GOVTC42 "COV BY OTH PUB PAYS PREM - R4/2 INT DT";
label variable GOVTC53 "COV BY OTH PUB PAYS PREM 12-31/R3 INT DT";
label variable GOVTC19 "COV BY OTH PUB PAYS PREM - 12/31/19";
label variable GOVCAT31 "CV BY OTH PUB PAYS PREM-ANY TIME IN R3/1";
label variable GOVCAT42 "CV BY OTH PUB PAYS PREM-ANY TIME IN R4/2";
label variable GOVCAT53 "CV BY OTH PUB PAYS PREM-ANY TIME IN R5/3";
label variable GOVCAT19 "CV OTH PUB PAYS PREM- R5/3 TIL 12/31/19";
label variable VAPROG31 "COV BY VA - R3/1 INT DT";
label variable VAPROG42 "COV BY VA - R4/2 INT DT";
label variable VAPROG53 "COV BY VA 12-31/R3 INT DT";
label variable VAPROG19 "COV BY VA- 12/31/19";
label variable VAPRAT31 "COV BY VA - ANY TIME IN R3/1";
label variable VAPRAT42 "COV BY VA - ANY TIME IN R4/2";
label variable VAPRAT53 "COV BY VA - ANY TIME IN R5/3";
label variable VAPRAT19 "COV BY VA-ANY TME IN R5/3 TIL 12/31/19";
label variable IHS31 "CV BY INDIAN HEALTH SERVICE- R3/1 INT DT";
label variable IHS42 "CV BY INDIAN HEALTH SERVICE- R4/2 INT DT";
label variable IHS53 "CV BY IHS 12-31/R3 INT DT";
label variable IHS19 "COV BY IHS - 12/31/19";
label variable IHSAT31 "COV BY IHS - ANY TIME IN R3/1";
label variable IHSAT42 "COV BY IHS - ANY TIME IN R4/2";
label variable IHSAT53 "COV BY IHS - ANY TIME IN R5/3";
label variable IHSAT19 "COV BY IHS-ANY TME IN R5/3 TIL 12/31/19";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK19 "COV BY PRIV INS (DK PLAN) - 12/31/19";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU19 "COV BY EMPL/UNION GRP INS - 12/31/19";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING19 "COV BY NON-GROUP INS - 12/31/19";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG19 "COV BY OTHER GROUP INS - 12/31/19";
label variable PRINEO31 "COV BY NON-ESI, PHOLDR OUT RU - R3/1 INT DT";
label variable PRINEO42 "COV BY NON-ESI, PHOLDR OUT RU - R4/2 INT DT";
label variable PRINEO53 "COV BY NON-ESI, PHOLDR OUT RU 12-31/R3 INT DT";
label variable PRINEO19 "COV BY NON-ESI, PHOLDR OUT RU - 12/31/19";
label variable PRIEUO31 "COV BY ESI, PHOLDR OUTSIDE RU - R3/1 INT";
label variable PRIEUO42 "COV BY ESI, PHOLDR OUTSIDE RU - R4/2 INT";
label variable PRIEUO53 "CV BY ESI, PHLDR OUTSIDE RU 12-31/R3 INT";
label variable PRIEUO19 "COV BY ESI, PHOLDR OUTSIDE RU - 12/31/19";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX19 "PRIV EXCHANGE INSURANCE ON 12/31/19";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV19 "COV BY PRIV HLTH INS - 12/31/19";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT19 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/19";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB19X "COV BY PUBLIC INS - 12/31/19 (ED)";
label variable PUBAT31X "COV BY PUBLIC - ANY TIME IN R3/1";
label variable PUBAT42X "COV BY PUBLIC - ANY TIME IN R4/2";
label variable PUBAT53X "COV BY PUBLIC - ANY TIME IN R5/3";
label variable PUBAT19X "COV BY PUBLIC - R5/3 UNTIL 12/31/19";
label variable VERFLG31 "PID GAINED COVG THRU VERIFICATION R3/1";
label variable VERFLG42 "PID GAINED COVG THRU VERIFICATION R4/2";
label variable VERFLG19 "PID GAINED COVG THRU VERIFICATION IN R5/R3 UNTIL 12/31/19";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS19X "INSURED - 12/31/19 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT19X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/19";
label variable DENTIN31 "DENTAL INSURANCE - ANY TIME IN RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - ANY TIME IN RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - ANY TIME IN RD 5/3";
label variable DNTINS31 "DENTAL INS - ANY TIME IN RD 3/1 IN 2019";
label variable DNTINS19 "DENTL INS-ANY TIME IN R5/R3 TIL 12/31/19";
label variable PMEDIN31 "PMED INS - ANY TIME IN RD 3/1";
label variable PMEDIN42 "PMEDINS - ANY TIME IN RD 4/2";
label variable PMEDIN53 "PMEDINS - ANY TIME IN RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 2019";
label variable PMDINS19 "PMED INS - R5/R3 UNTIL 12/31/19";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH19 "TOTAL HEALTH CARE CHARGES 19, EXCL RX";
label variable TOTEXP19 "TOTAL HEALTH CARE EXP 19";
label variable TOTSLF19 "TOTAL AMT PAID BY SELF/FAMILY 19";
label variable TOTMCR19 "TOTAL AMT PAID BY MEDICARE 19";
label variable TOTMCD19 "TOTAL AMT PAID BY MEDICAID 19";
label variable TOTPRV19 "TOTAL AMT PAID BY PRIVATE INS 19";
label variable TOTVA19 "TOTAL AMT PAID BY VA/CHAMPVA 19";
label variable TOTTRI19 "TOTAL AMT PAID BY TRICARE 19";
label variable TOTOFD19 "TOTAL AMT PAID BY OTHER FEDERAL 19";
label variable TOTSTL19 "TOTAL AMT PAID BY OTH ST/LOCAL 19";
label variable TOTWCP19 "TOTAL AMT PAID BY WORKERS COMP 19";
label variable TOTOSR19 "TOTAL AMT PAID BY OTHER SOURCES 19";
label variable TOTPTR19 "TOTAL AMT PAID BY PRV & TRI 19";
label variable TOTOTH19 "TOTAL AMT PAID BY OTH COMBINED 19";
label variable OBTOTV19 "# OFFICE-BASED PROVIDER VISITS 2019";
label variable OBVTCH19 "OFFICE-BASED PROVIDER VISIT CHARGES 19";
label variable OBVEXP19 "TOTAL OFFICE-BASED EXP 19";
label variable OBVSLF19 "ALL OFFICE VISITS - SELF/FAMILY AMT 19";
label variable OBVMCR19 "ALL OFFICE VISITS - MEDICARE AMT 19";
label variable OBVMCD19 "ALL OFFICE VISITS - MEDICAID AMT 19";
label variable OBVPRV19 "ALL OFFICE VISITS - PRIVATE INS AMT 19";
label variable OBVVA19 "ALL OFFICE VISITS-VA/CHAMPVA AMT 19";
label variable OBVTRI19 "ALL OFFICE VISITS-TRICARE AMT 19";
label variable OBVOFD19 "ALL OFFICE VISITS-OTHER FEDERAL AMT 19";
label variable OBVSTL19 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 19";
label variable OBVWCP19 "ALL OFFICE VISITS - WORKERS COMP AMT 19";
label variable OBVOSR19 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 19";
label variable OBVPTR19 "ALL OFFICE VISITS - PRV & TRI AMT 19";
label variable OBVOTH19 "ALL OFFICE VISITS - OTH COMBINED AMT 19";
label variable OBDRV19 "# OFFICE-BASED PHYSICIAN VISITS 19";
label variable OBDTCH19 "OFFICE-BASED PHYSICIAN VISIT CHARGES 19";
label variable OBDEXP19 "TOTAL OFF-BASED DR EXP 19";
label variable OBDSLF19 "DR OFFICE VISITS - SELF/FAMILY AMT 19";
label variable OBDMCR19 "DR OFFICE VISITS - MEDICARE AMT 19";
label variable OBDMCD19 "DR OFFICE VISITS - MEDICAID AMT 19";
label variable OBDPRV19 "DR OFFICE VISITS - PRIVATE INS AMT 19";
label variable OBDVA19 "DR OFFICE VISITS - VA/CHAMPVA AMT 19";
label variable OBDTRI19 "DR OFFICE VISITS - TRICARE AMT 19";
label variable OBDOFD19 "DR OFFICE VISITS - OTHER FEDERAL AMT 19";
label variable OBDSTL19 "DR OFFICE VISITS - OTH ST/LOCAL AMT 19";
label variable OBDWCP19 "DR OFFICE VISITS - WORKERS COMP AMT 19";
label variable OBDOSR19 "DR OFF VSTS - OTH UNCLASS SRCE AMT 19";
label variable OBDPTR19 "DR OFFICE VISITS - PRV & TRI AMT 19";
label variable OBDOTH19 "DR OFFICE VISITS - OTH COMBINED AMT 19";
label variable OPTOTV19 "# OUTPATIENT DEPT PROVIDER VISITS 2019";
label variable OPTTCH19 "OPD FACILITY + DR VISIT CHARGES - 19";
label variable OPTEXP19 "TOTAL OUTPATIENT FAC + DR EXP 19";
label variable OPTSLF19 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 19";
label variable OPTMCR19 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 19";
label variable OPTMCD19 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 19";
label variable OPTPRV19 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 19";
label variable OPTVA19 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 19";
label variable OPTTRI19 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 19";
label variable OPTOFD19 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 19";
label variable OPTSTL19 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 19";
label variable OPTWCP19 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 19";
label variable OPTOSR19 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 19";
label variable OPTPTR19 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 19";
label variable OPTOTH19 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 19";
label variable OPFTCH19 "OPD PROVIDER VISIT CHARGES - FAC 19";
label variable OPFEXP19 "TOTAL OUTPATIENT FACILITY EXP 19";
label variable OPFSLF19 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 19";
label variable OPFMCR19 "ALL OPD VISITS-MEDICARE AMT-FAC 19";
label variable OPFMCD19 "ALL OPD VISITS-MEDICAID AMT-FAC 19";
label variable OPFPRV19 "ALL OPD VISITS-PRIV INS AMT-FAC 19";
label variable OPFVA19 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 19";
label variable OPFTRI19 "ALL OPD VISITS-TRICARE AMT-FAC 19";
label variable OPFOFD19 "ALL OPD VISITS-OTHER FED AMT-FAC 19";
label variable OPFSTL19 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 19";
label variable OPFWCP19 "ALL OPD VISITS-WORKERS COMP AMT-FAC 19";
label variable OPFOSR19 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 19";
label variable OPFPTR19 "ALL OPD VISITS - PRV & TRI AMT-FAC 19";
label variable OPFOTH19 "ALL OPD VISITS - OTH COMBINED AMT-FAC 19";
label variable OPDEXP19 "TOTAL OUTPATIENT PROVIDER EXP 19";
label variable OPDTCH19 "OPD PROVIDER VISIT CHARGES - DR 19";
label variable OPDSLF19 "ALL OPD VISITS-SELF/FAMILY AMT-DR 19";
label variable OPDMCR19 "ALL OPD VISITS-MEDICARE AMT-DR 19";
label variable OPDMCD19 "ALL OPD VISITS-MEDICAID AMT-DR 19";
label variable OPDPRV19 "ALL OPD VISITS-PRIV INS AMT-DR 19";
label variable OPDVA19 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 19";
label variable OPDTRI19 "ALL OPD VISITS-TRICARE AMT-DR 19";
label variable OPDOFD19 "ALL OPD VISITS-OTHER FED AMT-DR 19";
label variable OPDSTL19 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 19";
label variable OPDWCP19 "ALL OPD VISITS-WORKERS COMP AMT-DR 19";
label variable OPDOSR19 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 19";
label variable OPDPTR19 "ALL OPD VISITS-PRV & TRI AMT -DR 19";
label variable OPDOTH19 "ALL OPD VISITS-OTH COMBINED AMT-DR 19";
label variable OPDRV19 "# OUTPATIENT DEPT PHYSICIAN VISITS 2019";
label variable OPVTCH19 "OPD PHYSICIAN VISIT CHARGES - FAC 19";
label variable OPVEXP19 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 19";
label variable OPVSLF19 "OPD DR VISITS-SELF/FAMILY AMT-FAC 19";
label variable OPVMCR19 "OPD DR VISITS-MEDICARE AMT-FAC 19";
label variable OPVMCD19 "OPD DR VISITS-MEDICAID AMT-FAC 19";
label variable OPVPRV19 "OPD DR VISITS-PRIV INS AMT-FAC 19";
label variable OPVVA19 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 19";
label variable OPVTRI19 "OPD DR VISITS-TRICARE AMT-FAC 19";
label variable OPVOFD19 "OPD DR VISITS-OTHER FED AMT-FAC 19";
label variable OPVSTL19 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 19";
label variable OPVWCP19 "OPD DR VISITS-WORKERS COMP AMT-FAC 19";
label variable OPVOSR19 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 19";
label variable OPVPTR19 "OPD DR VISITS - PRV & TRI AMT-FAC 19";
label variable OPVOTH19 "OPD DR VISITS - OTH COMBINED AMT-FAC 19";
label variable OPSEXP19 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 19";
label variable OPSTCH19 "OPD PHYSICIAN VISIT CHARGES - DR 19";
label variable OPSSLF19 "OPD DR VISITS-SELF/FAMILY AMT-DR 19";
label variable OPSMCR19 "OPD DR VISITS-MEDICARE AMT-DR 19";
label variable OPSMCD19 "OPD DR VISITS-MEDICAID AMT-DR 19";
label variable OPSPRV19 "OPD DR VISITS-PRIV INS AMT-DR 19";
label variable OPSVA19 "OPD DR VISITS-VA/CHAMPVA AMT-DR 19";
label variable OPSTRI19 "OPD DR VISITS-TRICARE AMT-DR 19";
label variable OPSOFD19 "OPD DR VISITS-OTHER FED AMT-DR 19";
label variable OPSSTL19 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 19";
label variable OPSWCP19 "OPD DR VISITS-WORKERS COMP AMT-DR 19";
label variable OPSOSR19 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 19";
label variable OPSPTR19 "OPD DR VISITS - PRV & TRI AMT-DR 19";
label variable OPSOTH19 "OPD DR VISITS -OTH COMBINED AMT-DR 19";
label variable ERTOT19 "# EMERGENCY ROOM VISITS 2019";
label variable ERTTCH19 "ER FACILITY + DR VISIT CHARGES 19";
label variable ERTEXP19 "TOTAL ER FACILITY + DR EXP 19";
label variable ERTSLF19 "ER-SELF/FAMILY AMT-(FAC+DR) 19";
label variable ERTMCR19 "ER-MEDICARE AMT-(FAC+DR) 19";
label variable ERTMCD19 "ER-MEDICAID AMT-(FAC+DR) 19";
label variable ERTPRV19 "ER-PRIV INS AMT-(FAC+DR) 19";
label variable ERTVA19 "ER-VA/CHAMPVA AMT-(FAC+DR) 19";
label variable ERTTRI19 "ER-TRICARE AMT-(FAC+DR) 19";
label variable ERTOFD19 "ER-OTHER FED AMT-(FAC+DR) 19";
label variable ERTSTL19 "ER-OTH ST/LOCAL AMT-(FAC+DR) 19";
label variable ERTWCP19 "ER-WORKERS COMP AMT-(FAC+DR) 19";
label variable ERTOSR19 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 19";
label variable ERTPTR19 "ER-PRV & TRI AMT (FAC+DR) 19";
label variable ERTOTH19 "ER -OTH COMBINED AMT (FAC+DR) 19";
label variable ERFTCH19 "ER FACILITY VISIT CHARGES 19";
label variable ERFEXP19 "TOTAL ER FACILITY EXP 19";
label variable ERFSLF19 "ER-SELF/FAMILY AMT - FAC 19";
label variable ERFMCR19 "ER-MEDICARE AMT - FAC 19";
label variable ERFMCD19 "ER-MEDICAID AMT - FAC 19";
label variable ERFPRV19 "ER-PRIVATE INS AMT - FAC 19";
label variable ERFVA19 "ER-VA/CHAMPVA AMT - FAC 19";
label variable ERFTRI19 "ER-TRICARE AMT - FAC 19";
label variable ERFOFD19 "ER-OTHER FEDERAL AMT - FAC 19";
label variable ERFSTL19 "ER-OTH ST/LOCAL AMT - FAC 19";
label variable ERFWCP19 "ER-WORKERS COMP AMT - FAC 19";
label variable ERFOSR19 "ER-OTH UNCLASS SRCE AMT - FAC 19";
label variable ERFPTR19 "ER-PRV & TRI AMT - FAC 19";
label variable ERFOTH19 "ER-OTH COMBINED AMT - FAC 19";
label variable ERDEXP19 "TOTAL EMERGENCY ROOM DR EXP 19";
label variable ERDTCH19 "ER DOCTOR VISIT CHARGES 19";
label variable ERDSLF19 "ER-SELF/FAMILY AMT - DR 19";
label variable ERDMCR19 "ER-MEDICARE AMT - DR 19";
label variable ERDMCD19 "ER-MEDICAID AMT - DR 19";
label variable ERDPRV19 "ER-PRIVATE INS AMT - DR 19";
label variable ERDVA19 "ER-VA/CHAMPVA AMT - DR 19";
label variable ERDTRI19 "ER-TRICARE AMT - DR 19";
label variable ERDOFD19 "ER-OTHER FED AMT - DR 19";
label variable ERDSTL19 "ER-OTH ST/LOCAL AMT - DR 19";
label variable ERDWCP19 "ER-WORKERS COMP AMT - DR 19";
label variable ERDOSR19 "ER-OTH UNCLASS SRCE AMT - DR 19";
label variable ERDPTR19 "ER-PRV & TRI AMT - DR 19";
label variable ERDOTH19 "ER-OTH COMBINED AMT - DR 19";
label variable IPDIS19 "# HOSPITAL DISCHARGES 2019";
label variable IPTEXP19 "TOT HOSP IP FACILITY + DR EXP 19";
label variable IPTTCH19 "IP HOSP STAY CHARGES (FAC+DR) 19";
label variable IPTSLF19 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 19";
label variable IPTMCR19 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 19";
label variable IPTMCD19 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 19";
label variable IPTPRV19 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 19";
label variable IPTVA19 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 19";
label variable IPTTRI19 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 19";
label variable IPTOFD19 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 19";
label variable IPTSTL19 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 19";
label variable IPTWCP19 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 19";
label variable IPTOSR19 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 19";
label variable IPTPTR19 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 19";
label variable IPTOTH19 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 19";
label variable IPFEXP19 "TOT HOSP IP FACILITY EXP-19";
label variable IPFTCH19 "IP HOSP STAY CHARGES - FAC 19";
label variable IPFSLF19 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 19";
label variable IPFMCR19 "IP HOSP STAZ-MEDICARE AMT-FAC 19";
label variable IPFMCD19 "IP HOSP STAZ-MEDICAID AMT-FAC 19";
label variable IPFPRV19 "IP HOSP STAZ-PRIV INS AMT-FAC 19";
label variable IPFVA19 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 19";
label variable IPFTRI19 "IP HOSP STAZ-TRICARE AMT-FAC 19";
label variable IPFOFD19 "IP HOSP STAZ-OTHER FED AMT-FAC 19";
label variable IPFSTL19 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 19";
label variable IPFWCP19 "IP HOSP STAZ-WORKERS COMP AMT-FAC 19";
label variable IPFOSR19 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 19";
label variable IPFPTR19 "IP HOSP STAZ-PRV & TRI AMT-FAC 19";
label variable IPFOTH19 "IP HOSP STAZ-OTH COMBINED AMT-FAC 19";
label variable IPDEXP19 "TOTL HOSP STAZ DR EXP 19";
label variable IPDTCH19 "IP HOSP STAY CHARGES - DR 19";
label variable IPDSLF19 "IP HOSP STAZ-SELF/FAMILY AMT-DR 19";
label variable IPDMCR19 "IP HOSP STAZ-MEDICARE AMT- DR 19";
label variable IPDMCD19 "IP HOSP STAZ-MEDICAID AMT-DR 19";
label variable IPDPRV19 "IP HOSP STAZ-PRIV INS AMT-DR 19";
label variable IPDVA19 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 19";
label variable IPDTRI19 "IP HOSP STAZ-TRICARE AMT-DR 19";
label variable IPDOFD19 "IP HOSP STAZ-OTHER FED AMT-DR 19";
label variable IPDSTL19 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 19";
label variable IPDWCP19 "IP HOSP STAZ-WORKERS COMP AMT-DR 19";
label variable IPDOSR19 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 19";
label variable IPDPTR19 "IP HOSP STAZ-PRV & TRI AMT-DR 19";
label variable IPDOTH19 "IP HOSP STAZ-OTH COMBINED AMT-DR 19";
label variable IPNGTD19 "# NIGHTS IN HOSP FOR DISCHARGES, 2019";
label variable DVTOT19 "# DENTAL CARE VISITS 2019";
label variable DVTTCH19 "TOTAL DENTAL CARE VISIT CHARGES 19";
label variable DVTEXP19 "TOTAL DENTAL CARE EXP 19";
label variable DVTSLF19 "ALL DENTAL CARE - SELF/FAMILY AMT 19";
label variable DVTMCR19 "ALL DENTAL CARE - MEDICARE AMT 19";
label variable DVTMCD19 "ALL DENTAL CARE - MEDICAID AMT 19";
label variable DVTPRV19 "ALL DENTAL CARE - PRIVATE INS AMT 19";
label variable DVTVA19 "ALL DENTAL CARE - VA/CHAMPVA AMT 19";
label variable DVTTRI19 "ALL DENTAL CARE - TRICARE AMT 19";
label variable DVTOFD19 "ALL DENTAL CARE - OTHER FEDRL AMT 19";
label variable DVTSTL19 "ALL DENTAL CARE - OTH ST/LOCAL AMT 19";
label variable DVTWCP19 "ALL DENTAL CARE - WORKERS COMP AMT 19";
label variable DVTOSR19 "ALL DENT CARE-OT UNCLASS SRCE AMT 19";
label variable DVTPTR19 "ALL DENTAL CARE - PRV & TRI AMT 19";
label variable DVTOTH19 "ALL DENTAL CARE - OTH COMBINED AMT 19";
label variable HHTOTD19 "# HOME HEALTH PROVIDER DAYS 2019";
label variable HHAGD19 "# AGENCY HOME HEALTH PROVIDER DAYS 2019";
label variable HHATCH19 "HOME HEALTH AGENCY VISIT CHARGES 19";
label variable HHAEXP19 "TOTAL HOME HEALTH AGENCY EXP 19";
label variable HHASLF19 "HOME HLTH AGENCY - SELF/FAMILY AMT 19";
label variable HHAMCR19 "HOME HLTH AGENCY - MEDICARE AMT 19";
label variable HHAMCD19 "HOME HLTH AGENCY - MEDICAID AMT 19";
label variable HHAPRV19 "HOME HLTH AGENCY - PRIVATE INS AMT 19";
label variable HHAVA19 "HOME HLTH AGENCY-VA/CHAMPVA AMT 19";
label variable HHATRI19 "HOME HLTH AGENCY-TRICARE AMT 19";
label variable HHAOFD19 "HOME HLTH AGENCY - OTHER FED AMT 19";
label variable HHASTL19 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 19";
label variable HHAWCP19 "HOME HLTH AGENCY - WORKERS COMP AMT 19";
label variable HHAOSR19 "H HLTH AGENCY - OT UNCLASS SRCE AMT 19";
label variable HHAPTR19 "HOME HLTH AGENCY - PRV & TRI AMT 19";
label variable HHAOTH19 "HOME HLTH AGENCY - OTH COMBINED AMT 19";
label variable HHINDD19 "# NON-AGENCY HOME HLTH PROVIDR DAYS 2019";
label variable HHNTCH19 "HOME HEALTH NON-AGENCY VISIT CHARGES 19";
label variable HHNEXP19 "TOTAL HOME HEALTH NON-AGNCY EXP 19";
label variable HHNSLF19 "HOME HLTH NON-AGNCY - SELF/FAM AMT 19";
label variable HHNMCD19 "HOME HLTH NON-AGNCY - MEDICAID AMT 19";
label variable HHNMCR19 "HOME HLTH NON-AGNCY - MEDICARE AMT 19";
label variable HHNPRV19 "HOME HLTH NON-AGNCY - PRIV INS AMT 19";
label variable HHNVA19 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 19";
label variable HHNTRI19 "HOME HLTH NON-AGNCY-TRICARE AMT 19";
label variable HHNOFD19 "HOME HLTH NON-AGNCY-OTHR FED AMT 19";
label variable HHNSTL19 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 19";
label variable HHNWCP19 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 19";
label variable HHNOSR19 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 19";
label variable HHNPTR19 "HOME HLTH NON-AGNCY - PRV & TRI AMT 19";
label variable HHNOTH19 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 19";
label variable HHINFD19 "# INFORMAL HOME HLTH PROVIDER DAYS 2019";
label variable VISEXP19 "TOTAL GLASSES/CONTACT LENS EXP 19";
label variable VISTCH19 "GLASSES/CONTACT LENSES CHARGES 19";
label variable VISSLF19 "GLASSES/CNTCT LENSES -SELF/FAM AMT 19";
label variable VISMCR19 "GLASSES/CNTCT LENSES-MEDICARE AMT 19";
label variable VISMCD19 "GLASSES/CNTCT LENSES-MEDICAID AMT 19";
label variable VISPRV19 "GLASSES/CNTCT LENSES-PRIV INS AMT 19";
label variable VISVA19 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 19";
label variable VISTRI19 "GLASSES/LENSES-TRICARE AMT 19";
label variable VISOFD19 "GLASSES/CNTCT LENSES-OTHR FED AMT 19";
label variable VISSTL19 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 19";
label variable VISWCP19 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 19";
label variable VISOSR19 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 19";
label variable VISPTR19 "GLASSES/CNTCT LENSES-PRV & TRI AMT 19";
label variable VISOTH19 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 19";
label variable OTHTCH19 "OTHER EQUP/SUPPLIES CHARGES 19";
label variable OTHEXP19 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 19";
label variable OTHSLF19 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 19";
label variable OTHMCR19 "OTHER EQUP/SUPPLIES-MEDICARE AMT 19";
label variable OTHMCD19 "OTHER EQUP/SUPPLIES-MEDICAID AMT 19";
label variable OTHPRV19 "OTHER EQUP/SUPPLIES-PRIV INS AMT 19";
label variable OTHVA19 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 19";
label variable OTHTRI19 "OTHER EQUP/SUPPLY-TRICARE AMT 19";
label variable OTHOFD19 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 19";
label variable OTHSTL19 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 19";
label variable OTHWCP19 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 19";
label variable OTHOSR19 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 19";
label variable OTHPTR19 "OTHER EQUP/SUPPLY - PRV & TRI AMT 19";
label variable OTHOTH19 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 19";
label variable RXTOT19 "# PRESC MEDS INCL REFILLS 19";
label variable RXEXP19 "TOTAL RX-EXP 19";
label variable RXSLF19 "TOTAL RX-SELF/FAMILY AMT 19";
label variable RXMCR19 "TOTAL RX-MEDICARE AMT 19";
label variable RXMCD19 "TOTAL RX-MEDICAID AMT 19";
label variable RXPRV19 "TOTAL RX-PRIVATE INS AMT 19";
label variable RXVA19 "TOTAL RX-VA/CHAMPVA AMT 19";
label variable RXTRI19 "TOTAL RX-TRICARE AMT 19";
label variable RXOFD19 "TOTAL RX-OTHER FED AMT 19";
label variable RXSTL19 "TOTAL RX-OTHER ST/LOCAL AMT 19";
label variable RXWCP19 "TOTAL RX-WORKERS COMP AMT 19";
label variable RXOSR19 "TOT RX-OTH UNCLASS SRCE AMT 19";
label variable RXPTR19 "TOTAL RX-PRV & TRI AMT 19";
label variable RXOTH19 "TOTAL RX-OTH COMBINED AMT 19";
label variable PERWT19F "FINAL PERSON WEIGHT, 2019";
label variable FAMWT19F "FINAL FAMILY WEIGHT, 2019";
label variable FAMWT19C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/19";
label variable SAQWT19F "FINAL SAQ PERSON WEIGHT, 2019";
label variable VSAQW19F "FINAL VSAQ PERSON WEIGHT, 2019";
label variable DIABW19F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2019";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2019";


*DEFINE VALUE LABELS FOR REPORTS;
label define H2160001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H2160002X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2160003X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2160004X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2160005X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160006X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2160007X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H2160008X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2160009X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160010X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160011X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2160012X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2160013X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160014X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2160015X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2160016X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160017X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160018X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160019X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160020X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160021X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160022X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160023X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H2160024X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160025X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160026X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160027X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2160028X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2160029X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160030X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2160031X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H2160032X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160033X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160034X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2160035X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160036X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H2160037X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2160038X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H2160039X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2160040X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 SELF ADMINISTERED"
         2 "2 HUSBAND OR WIFE"
         3 "3 UNMARRIED PARTNER"
         4 "4 MOTHER, FATHER OR GUARDIAN"
         5 "5 SON OR DAUGHTER"
         6 "6 OTHER RELATIVE"
         7 "7 NOT RELATED" ;

label define H2160041X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2160042X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160043X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160044X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160045X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2160046X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160047X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160048X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160049X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160050X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160051X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H2160052X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160053X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160054X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160055X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2160056X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2160057X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160058X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160059X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160060X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2160061X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160062X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160063X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160064X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160065X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160066X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160067X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160068X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H2160069X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160070X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160071X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160072X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160073X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160074X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160075X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160076X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160077X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160078X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160079X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160080X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1  WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3  WITHIN PAST 5 YEARS"
         4 "4  MORE THAN 5 YEARS"
         5 "5  NEVER" ;

label define H2160081X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H2160082X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160083X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160084X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160085X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2160086X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2019 "2019 YEAR" ;

label define H2160087X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2019 "2019 YEAR"
         2020 "2020 YEAR" ;

label define H2160088X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2160089X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160090X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160091X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160092X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160093X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160094X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160095X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160096X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160097X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2160098X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160099X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160100X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160101X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160102X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160103X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160104X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160105X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160106X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160107X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160108X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160109X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160110X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160111X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160112X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H2160113X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160114X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160115X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160116X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160117X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160118X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160119X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160120X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2160121X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2160122X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H2160123X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160124X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160125X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160126X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160127X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160128X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160129X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160130X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160131X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160132X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160133X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160134X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160135X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160136X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160137X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160138X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160139X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160140X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160141X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160142X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160143X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160144X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160145X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160146X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160147X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160148X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160152X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160153X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H2160155X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160156X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160157X
         0 "0 NOT ELIGIBLE FOR DCS"
         1 "1 ELIGIBLE FOR DCS AND HAS DCS DATA"
         2 "2 ELIGIBLE FOR DCS, BUT NO DCS DATA" ;

label define H2160158X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2160159X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2160160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160163X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160164X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160165X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160166X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160167X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160168X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160169X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160170X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160171X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2160172X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2160173X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2160174X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2160175X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2160176X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2160177X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160178X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160179X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160180X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160183X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160184X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160185X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -8 "-8 DK"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H2160186X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160187X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160188X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160189X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160190X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160191X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160192X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160193X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160194X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H2160195X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160196X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160197X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160198X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160199X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160200X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160201X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160202X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160203X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160204X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160205X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160206X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160207X
         -1 "-1  INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160208X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160209X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160210X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160211X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160212X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160213X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160214X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160215X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160216X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160217X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160218X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2160219X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160220X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H2160221X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2160222X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2160223X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2160224X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2160225X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160226X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160227X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H2160228X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 3/1" ;

label define H2160229X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H2160230X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 4/2" ;

label define H2160231X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H2160232X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 5/3" ;

label define H2160233X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160234X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160235X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160236X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160237X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2160238X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2160239X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2019 "2019 YEAR" ;

label define H2160240X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2019 "2019 YEAR"
         2020 "2020 YEAR" ;

label define H2160241X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160242X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160243X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160244X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160245X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2160246X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160247X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160248X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160249X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160250X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160251X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         2 "2 PERSONS"
         3 "3 PERSONS" ;

label define H2160252X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2160253X
         -1 "-1 INAPPLICABLE"
         1 "1 NUMBER OF PERSONS"
         2 "2 NUMBER OF PERSONS"
         3 "3 NUMBER OF PERSONS" ;

label define H2160254X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160255X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H2160256X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H2160257X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H2160258X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2160259X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160260X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160261X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2160262X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160263X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2160264X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2160265X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2160266X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2160267X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2160268X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160269X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160270X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160277X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160280X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160281X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160282X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160283X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160284X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160285X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160286X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160287X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160288X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160289X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160290X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160291X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160294X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160296X
         1 "1 YES"
         2 "2 NO" ;

label define H2160297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160300X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160301X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160304X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160305X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160307X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160308X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160309X
         1 "1 YES"
         2 "2 NO" ;

label define H2160310X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160311X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160312X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160313X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160314X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160315X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160316X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160317X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160318X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160319X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160320X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160321X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160322X
         1 "1 YES"
         2 "2 NO" ;

label define H2160323X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160324X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160325X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160326X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160327X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160328X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160329X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160330X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160331X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160332X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160333X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160334X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160335X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160336X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160337X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160338X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160339X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160340X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160341X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160342X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160343X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160344X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H2160345X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H2160346X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H2160347X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160348X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160349X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160350X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160423X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2160424X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2160425X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2160426X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2160427X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160428X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2160429X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND" ;

label define H2160430X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2160431X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND" ;

label define H2160432X
         0 "0 NO"
         1 "1 YES" ;

label define H2160433X
         0 "0 NO"
         1 "1 YES" ;

label define H2160434X
         0 "0 NO"
         1 "1 YES" ;

label define H2160435X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160436X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160437X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2160438X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160459X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160460X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160461X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160462X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160463X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160464X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2160465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160475X
         1 "1 IN-SCOPE ON 12/31/2019"
         2 "2 NOT IN-SCOPE ON 12/31/2019" ;

label define H2160476X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/19"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2160477X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/19"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2160478X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/19"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2160479X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/19"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2160480X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2019"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2019" ;

label define H2160481X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H2160482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160492X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H2160493X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160494X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H2160495X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160496X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160497X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160498X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160499X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160500X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160501X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160502X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160503X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160504X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2160505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160506X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160507X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 RATING OF LAST 30 DAYS" ;

label define H2160508X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H2160509X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160510X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H2160511X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H2160512X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160513X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H2160514X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2160515X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2160516X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2160517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160543X
         1 "1 YES"
         2 "2 NO" ;

label define H2160544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160546X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160547X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160548X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160557X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160558X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160559X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2160560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160574X
         1 "1 YES"
         2 "2 NO" ;

label define H2160575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160591X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160592X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160593X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160594X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160595X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160596X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160597X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160598X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160599X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160600X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160601X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160602X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2160603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160605X
         -1 "-1 INAPPLICALBE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160606X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160607X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2160608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160610X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160611X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160612X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160614X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160615X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160616X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160617X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160618X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160619X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2160620X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2160621X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2160622X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160623X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160624X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160625X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160626X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2160627X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160628X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160629X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160630X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DO NOT WANT TO WORK"
         91 "91 OTHER" ;

label define H2160631X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DO NOT WANT TO WORK"
         91 "91 OTHER" ;

label define H2160632X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DO NOT WANT TO WORK"
         91 "91 OTHER" ;

label define H2160633X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160634X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160635X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160636X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160637X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160638X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160639X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160640X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2160641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160645X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160647X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160649X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160650X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160651X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160652X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160653X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160654X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EVERY DAY"
         2 "2 SOME DAYS"
         3 "3 NOT AT ALL" ;

label define H2160655X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160656X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160657X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HEART MURMUR"
         10 "10 BRADYCARDIA/SLOW HEART RATE"
         2 "2 HEART ARRHYTHMIA/IRREGULAR HEARTBEAT"
         3 "3 BLOCKED OR CLOGGED ARTERY"
         4 "4 CONGESTIVE HEART FAILURE"
         5 "5 ATRIAL FIBRILLATION"
         6 "6 MITRAL VALVE PROLAPSE"
         7 "7 ENLARGED HEART"
         8 "8 HEART VALVE PROBLEMS"
         9 "9 TACHYCARDIA/RAPID HEART RATE"
         91 "91 OTHER SPECIFY" ;

label define H2160658X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160659X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2160660X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160661X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160662X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2160663X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2160664X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160665X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160666X
         23 "23 PANEL 23"
         24 "24 PANEL 24" ;

label define H2160667X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160669X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160671X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160673X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160674X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160675X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160700X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160701X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2160702X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2160703X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 RATING OF LAST 2 WEEKS" ;

label define H2160704X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160705X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H2160706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160711X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2160712X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2160713X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2160714X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160715X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160716X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160762X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160765X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H2160766X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 OWN PRACTICE, NOT PART OF GROUP/FAC"
         2 "2 PRACTICE ASSOCIATED WITH GROUP/FAC" ;

label define H2160767X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160791X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160792X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160793X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160812X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160813X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H2160814X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2160815X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2160816X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2160817X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2160818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160822X
         1 "1 YES"
         2 "2 NO" ;

label define H2160823X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2160824X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2160825X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2160826X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160827X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160828X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160835X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160836X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160837X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160839X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2160840X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2160841X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2160842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160854X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160863X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160867X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2160868X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2160869X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H2160870X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H2160871X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H2160872X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2160873X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2160874X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2160875X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2160876X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2160877X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2160878X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2160879X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2160880X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2160881X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2160882X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2160883X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2160884X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2160885X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2160886X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160887X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160888X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160889X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H2160890X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160891X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160892X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2160893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160896X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2160897X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2160898X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2160899X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2160900X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU" ;

label define H2160901X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU" ;

label define H2160902X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU" ;

label define H2160903X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU" ;

label define H2160904X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160905X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H2160906X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160907X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160908X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160912X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160913X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160914X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160915X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2160916X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160917X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160918X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160919X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160923X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160924X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2160925X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2160926X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2160927X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H2160928X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2160929X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2160930X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2160931X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2160932X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160933X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160934X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160935X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2160936X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2160937X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2160938X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160939X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160940X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2160941X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160942X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160943X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160944X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2160945X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H2160946X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2160947X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160948X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H2160949X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2160950X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2160951X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2160952X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H2160953X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160960X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160961X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160962X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160963X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160968X
         1 "1 YES"
         2 "2 NO" ;

label define H2160969X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160970X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160971X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160976X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160977X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160978X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160979X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160980X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160981X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160983X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160984X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160985X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160986X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160987X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160988X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160989X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2160990X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160991X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H2160992X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160993X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2160994X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2160995X
         1 "1 YES"
         2 "2 NO" ;

label define H2160996X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160997X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2160998X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2160999X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161000X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2161001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161002X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161003X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161004X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 DID NOT RECEIVE HEALTH CARE SERVICES AT THE VA IN THE LAST 12 MONTHS"
         1 "1 YES"
         2 "2 NO" ;

label define H2161005X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161006X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2161007X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         2018 "2018 YEAR"
         2019 "2019 YEAR"
         2020 "2020 YEAR" ;

label define H2161008X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161009X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161010X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161011X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161012X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -16 "-16 NO ADUTY RPTD, BUT RCVD VA HCARE SVC"
         1 "1 NO, NEVER SERVED IN THE MILITARY"
         2 "2 YES, ADUTY ONLY TRAIN RESERVES/NATL GUARD"
         3 "3 YES, AND I AM STILL ON ACTIVE DUTY"
         4 "4 YES, ACTIVE DUTY IN THE PAST, BUT NOT NOW" ;

label define H2161013X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161014X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161015X
         1 "1 YES"
         2 "2 NO" ;

label define H2161016X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161017X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161018X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161019X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161020X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161021X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161022X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161023X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161024X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161025X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161026X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161027X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161028X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161029X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161030X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161031X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161032X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161033X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161034X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161035X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161036X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161037X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161038X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161039X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT RECV HCARE SVC OUTSD VA IN LAST 12 MOS"
         1 "1 YES"
         2 "2 NO" ;

label define H2161040X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161041X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161042X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161043X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161044X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2161045X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2161046X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161052X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161059X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161060X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2161061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161065X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161066X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161067X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 SELF ADMINISTERED"
         2 "2 HUSBAND OR WIFE"
         3 "3 UNMARRIED PARTNER"
         4 "4 MOTHER, FATHER, OR GUARDIAN"
         5 "5 SON OR DAUGHTER"
         6 "6 OTHER RELATIVE"
         7 "7 NOT RELATED" ;

label define H2161068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2161069X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161070X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161071X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161072X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161073X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161074X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2161075X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161076X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161077X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 DID NOT RECEIVE HEALTH CARE SERVICES AT THE VA IN THE LAST 12 MONTHS"
         1 "1 YES"
         2 "2 NO" ;

label define H2161078X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2161079X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2161080X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2161081X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2161082X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2161083X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2161084X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2161085X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2161086X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2161087X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H2161088X
         0 "0 NOT ELIGIBLE FOR VSAQ"
         1 "1 ELIGIBLE FOR VSAQ - HAS VSAQ DATA"
         2 "2 ELIGIBLE FOR VSAQ - NO VSAQ DATA" ;

label define H2161089X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2161090X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2161091X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2161092X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2161093X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2161094X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2161095X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2161096X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2161097X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JOB ENDED, TEMPORARY, SEASONAL, CONTRACT, ETC"
         10 "10 QUIT - ANY OTHER REASON"
         2 "2 BUSINESS CLOSED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS, INJURY, ANY HEALTH PROBLEM"
         5 "5 TERMINATED, FIRED, DISMISSED"
         6 "6 LAID OFF, LET GO"
         7 "7 QUIT - FAMILY REASON, MATERNITY LEAVE"
         8 "8 QUIT - SCHOOL"
         9 "9 QUIT - JOB RELATED REASON"
         91 "91 OTHER" ;

label define H2161098X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JOB ENDED, TEMPORARY, SEASONAL, CONTRACT, ETC"
         10 "10 QUIT - ANY OTHER REASON"
         2 "2 BUSINESS CLOSED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS, INJURY, ANY HEALTH PROBLEM"
         5 "5 TERMINATED, FIRED, DISMISSED"
         6 "6 LAID OFF, LET GO"
         7 "7 QUIT - FAMILY REASON, MATERNITY LEAVE"
         8 "8 QUIT - SCHOOL"
         9 "9 QUIT - JOB RELATED REASON"
         91 "91 OTHER" ;

label define H2161099X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER GETS SICK"
         2 "2 RECENTLY MOVED INTO AREA"
         3 "3 JUST CHANGED INSURANCE PLANS"
         4 "4 NO HEALTH INSURANCE, OTHER INSURANCE-RELATED REASON"
         5 "5 DO NOT KNOW WHERE TO GO FOR CARE"
         6 "6 USC IN THIS AREA NO LONGER AVAILABLE"
         7 "7 LIKES TO GO TO DIFFERENT PLACES FOR DIFFERENT HEALTH NEEDS"
         8 "8 DO NOT USE DOCTORS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H2161100X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H2160001X;
label value ACTDTY31 H2160002X;
label value ACTDTY42 H2160003X;
label value ACTDTY53 H2160004X;
label value ACTLIM31 H2160005X;
label value ADACLS42 H2160006X;
label value ADAPPT42 H2160007X;
label value ADCLIM42 H2160008X;
label value ADCMPM42 H2160009X;
label value ADCMPY42 H2160010X;
label value ADDAYA42 H2160011X;
label value ADDPRS42 H2160012X;
label value ADEFRT42 H2160013X;
label value ADEMLS42 H2160014X;
label value ADENGY42 H2160015X;
label value ADEXPL42 H2160016X;
label value ADEZUN42 H2160017X;
label value ADFFRM42 H2160018X;
label value ADFHLP42 H2160019X;
label value ADGENH42 H2160020X;
label value ADHDADDX H2160021X;
label value ADHDAGED H2160022X;
label value ADHECR42 H2160023X;
label value ADHOPE42 H2160024X;
label value ADILCR42 H2160025X;
label value ADILWW42 H2160026X;
label value ADINSA42 H2160027X;
label value ADINSB42 H2160028X;
label value ADINST42 H2160029X;
label value ADINTR42 H2160030X;
label value ADLANG42 H2160031X;
label value ADLHLP31 H2160032X;
label value ADLIST42 H2160033X;
label value ADMWCF42 H2160034X;
label value ADNERV42 H2160035X;
label value ADNSMK42 H2160036X;
label value ADOVER42 H2160037X;
label value ADPAIN42 H2160038X;
label value ADPCFL42 H2160039X;
label value ADPROX42 H2160040X;
label value ADPRST42 H2160041X;
label value ADPRTM42 H2160042X;
label value ADRESP42 H2160043X;
label value ADREST42 H2160044X;
label value ADRISK42 H2160045X;
label value ADRTCR42 H2160046X;
label value ADRTWW42 H2160047X;
label value ADSAD42 H2160048X;
label value ADSMOK42 H2160049X;
label value ADSNSP42 H2160050X;
label value ADSOCA42 H2160051X;
label value ADSPCL42 H2160052X;
label value ADTLHW42 H2160053X;
label value ADUPRO42 H2160054X;
label value ADWKLM42 H2160055X;
label value ADWRTH42 H2160056X;
label value AFRDCA42 H2160057X;
label value AFRDDN42 H2160058X;
label value AFRDPM42 H2160059X;
label value AFTHOU42 H2160060X;
label value AIDHLP31 H2160061X;
label value ALIIMP19 H2160062X;
label value ANGIAGED H2160063X;
label value ANGIDX H2160064X;
label value ANYLMI19 H2160065X;
label value ARTHAGED H2160066X;
label value ARTHDX H2160067X;
label value ARTHTYPE H2160068X;
label value ASACUT31 H2160069X;
label value ASATAK31 H2160070X;
label value ASDALY31 H2160071X;
label value ASEVFL31 H2160072X;
label value ASIANP42 H2160073X;
label value ASMRCN31 H2160074X;
label value ASPKFL31 H2160075X;
label value ASPREV31 H2160076X;
label value ASSTIL31 H2160077X;
label value ASTHAGED H2160078X;
label value ASTHDX H2160079X;
label value ASTHEP31 H2160080X;
label value ASWNFL31 H2160081X;
label value BEGRFM31 H2160082X;
label value BEGRFM42 H2160083X;
label value BEGRFM53 H2160084X;
label value BEGRFY31 H2160085X;
label value BEGRFY42 H2160086X;
label value BEGRFY53 H2160087X;
label value BENDIF31 H2160088X;
label value BLCKPR42 H2160089X;
label value BORNUSA H2160090X;
label value BPMLDX H2160091X;
label value BSNTY31 H2160092X;
label value BSNTY31H H2160093X;
label value BSNTY42 H2160094X;
label value BSNTY42H H2160095X;
label value BSNTY53 H2160096X;
label value BSNTY53H H2160097X;
label value BUSIMP19 H2160098X;
label value CABLADDR H2160099X;
label value CABREAST H2160100X;
label value CACERVIX H2160101X;
label value CACOLON H2160102X;
label value CALUNG H2160103X;
label value CALYMPH H2160104X;
label value CAMELANO H2160105X;
label value CANCERDX H2160106X;
label value CAOTHER H2160107X;
label value CAPROSTA H2160108X;
label value CASKINDK H2160109X;
label value CASKINNM H2160110X;
label value CAUTERUS H2160111X;
label value CHAPPT42 H2160112X;
label value CHBRON31 H2160113X;
label value CHCOUN42 H2160114X;
label value CHDAGED H2160115X;
label value CHDDX H2160116X;
label value CHEMPB42 H2160117X;
label value CHEXPL42 H2160118X;
label value CHEYRE42_M18 H2160119X;
label value CHGJ3142 H2160120X;
label value CHGJ4253 H2160121X;
label value CHHECR42 H2160122X;
label value CHILCR42 H2160123X;
label value CHILWW42 H2160124X;
label value CHLICO42 H2160125X;
label value CHLIHB42 H2160126X;
label value CHLIMI42 H2160127X;
label value CHLIMP19 H2160128X;
label value CHLIST42 H2160129X;
label value CHOIC31 H2160130X;
label value CHOIC42 H2160131X;
label value CHOIC53 H2160132X;
label value CHOLAGED H2160133X;
label value CHOLDX H2160134X;
label value CHPMCN42 H2160135X;
label value CHPMED42 H2160136X;
label value CHPMHB42 H2160137X;
label value CHPRTM42 H2160138X;
label value CHRESP42 H2160139X;
label value CHRTCR42 H2160140X;
label value CHRTWW42 H2160141X;
label value CHSERV42 H2160142X;
label value CHSPEC42_M18 H2160143X;
label value CHSRCN42 H2160144X;
label value CHSRHB42 H2160145X;
label value CHTHCO42 H2160146X;
label value CHTHER42 H2160147X;
label value CHTHHB42 H2160148X;
label value CMJHLD31 H2160149X;
label value CMJHLD42 H2160150X;
label value CMJHLD53 H2160151X;
label value COGLIM31 H2160152X;
label value CRFMPY42 H2160153X;
label value CSHCN42 H2160154X;
label value CSHIMP19 H2160155X;
label value DADPRO42 H2160156X;
label value DCSELIG H2160157X;
label value DDNWRK19 H2160158X;
label value DECIDE42 H2160159X;
label value DENTIN31 H2160160X;
label value DENTIN42 H2160161X;
label value DENTIN53 H2160162X;
label value DFCOG42 H2160163X;
label value DFDRSB42 H2160164X;
label value DFERND42 H2160165X;
label value DFHEAR42 H2160166X;
label value DFSEE42 H2160167X;
label value DFWLKC42 H2160168X;
label value DIABAGED H2160169X;
label value DIABDX_M18 H2160170X;
label value DIFFWG31 H2160171X;
label value DIFFWG42 H2160172X;
label value DIFFWG53 H2160173X;
label value DISVW31X H2160174X;
label value DISVW42X H2160175X;
label value DISVW53X H2160176X;
label value DIVIMP19 H2160177X;
label value DLAYCA42 H2160178X;
label value DLAYDN42 H2160179X;
label value DLAYPM42 H2160180X;
label value DNTINS19 H2160181X;
label value DNTINS31 H2160182X;
label value DOBMM H2160183X;
label value DOBYY H2160184X;
label value DSA1C53 H2160185X;
label value DSCB1853 H2160186X;
label value DSCGRP53 H2160187X;
label value DSCH1853 H2160188X;
label value DSCH1953 H2160189X;
label value DSCH2053 H2160190X;
label value DSCHNV53 H2160191X;
label value DSCINT53 H2160192X;
label value DSCNPC53 H2160193X;
label value DSCONF53 H2160194X;
label value DSCPCP53 H2160195X;
label value DSCPHN53 H2160196X;
label value DSDIA53 H2160197X;
label value DSDIET53 H2160198X;
label value DSEB1853 H2160199X;
label value DSEY1853 H2160200X;
label value DSEY1953 H2160201X;
label value DSEY2053 H2160202X;
label value DSEYNV53 H2160203X;
label value DSEYPR53 H2160204X;
label value DSFB1853 H2160205X;
label value DSFL1853 H2160206X;
label value DSFL1953 H2160207X;
label value DSFL2053 H2160208X;
label value DSFLNV53 H2160209X;
label value DSFT1853 H2160210X;
label value DSFT1953 H2160211X;
label value DSFT2053 H2160212X;
label value DSFTNV53 H2160213X;
label value DSINSU53 H2160214X;
label value DSKIDN53 H2160215X;
label value DSMED53 H2160216X;
label value DSPRX53 H2160217X;
label value DSVB1853 H2160218X;
label value DVTOT19 H2160219X;
label value EDUCYR H2160220X;
label value ELGRND19 H2160221X;
label value ELGRND31 H2160222X;
label value ELGRND42 H2160223X;
label value ELGRND53 H2160224X;
label value EMPHAGED H2160225X;
label value EMPHDX H2160226X;
label value EMPST31 H2160227X;
label value EMPST31H H2160228X;
label value EMPST42 H2160229X;
label value EMPST42H H2160230X;
label value EMPST53 H2160231X;
label value EMPST53H H2160232X;
label value ENDRFM19 H2160233X;
label value ENDRFM31 H2160234X;
label value ENDRFM42 H2160235X;
label value ENDRFM53 H2160236X;
label value ENDRFY19 H2160237X;
label value ENDRFY31 H2160238X;
label value ENDRFY42 H2160239X;
label value ENDRFY53 H2160240X;
label value ERTOT19 H2160241X;
label value EVRETIRE H2160242X;
label value EVRWRK H2160243X;
label value EXPLOP42 H2160244X;
label value FAMRFPYR H2160245X;
label value FAMS1231 H2160246X;
label value FAMSZE19 H2160247X;
label value FAMSZE31 H2160248X;
label value FAMSZE42 H2160249X;
label value FAMSZE53 H2160250X;
label value FAMSZEYR H2160251X;
label value FCRP1231 H2160252X;
label value FCSZ1231 H2160253X;
label value FILEDR19 H2160254X;
label value FILER19 H2160255X;
label value FLSTAT19 H2160256X;
label value FMRS1231 H2160257X;
label value FNGRDF31 H2160258X;
label value FOODMN19 H2160259X;
label value FOODST19 H2160260X;
label value FOODVL19 H2160261X;
label value FSAGT31 H2160262X;
label value FTSTU19X H2160263X;
label value FTSTU31X H2160264X;
label value FTSTU42X H2160265X;
label value FTSTU53X H2160266X;
label value GENDRP42 H2160267X;
label value GETTRB42 H2160268X;
label value GOVAAT19 H2160269X;
label value GOVAAT31 H2160270X;
label value GOVAAT42 H2160271X;
label value GOVAAT53 H2160272X;
label value GOVBAT19 H2160273X;
label value GOVBAT31 H2160274X;
label value GOVBAT42 H2160275X;
label value GOVBAT53 H2160276X;
label value GOVCAT19 H2160277X;
label value GOVCAT31 H2160278X;
label value GOVCAT42 H2160279X;
label value GOVCAT53 H2160280X;
label value GOVTA19 H2160281X;
label value GOVTA31 H2160282X;
label value GOVTA42 H2160283X;
label value GOVTA53 H2160284X;
label value GOVTB19 H2160285X;
label value GOVTB31 H2160286X;
label value GOVTB42 H2160287X;
label value GOVTB53 H2160288X;
label value GOVTC19 H2160289X;
label value GOVTC31 H2160290X;
label value GOVTC42 H2160291X;
label value GOVTC53 H2160292X;
label value GVAAP19 H2160293X;
label value GVAAU19 H2160294X;
label value GVADE19 H2160295X;
label value GVAEV19 H2160296X;
label value GVAFE19 H2160297X;
label value GVAJA19 H2160298X;
label value GVAJL19 H2160299X;
label value GVAJU19 H2160300X;
label value GVAMA19 H2160301X;
label value GVAMY19 H2160302X;
label value GVANO19 H2160303X;
label value GVAOC19 H2160304X;
label value GVASE19 H2160305X;
label value GVBAP19 H2160306X;
label value GVBAU19 H2160307X;
label value GVBDE19 H2160308X;
label value GVBEV19 H2160309X;
label value GVBFE19 H2160310X;
label value GVBJA19 H2160311X;
label value GVBJL19 H2160312X;
label value GVBJU19 H2160313X;
label value GVBMA19 H2160314X;
label value GVBMY19 H2160315X;
label value GVBNO19 H2160316X;
label value GVBOC19 H2160317X;
label value GVBSE19 H2160318X;
label value GVCAP19 H2160319X;
label value GVCAU19 H2160320X;
label value GVCDE19 H2160321X;
label value GVCEV19 H2160322X;
label value GVCFE19 H2160323X;
label value GVCJA19 H2160324X;
label value GVCJL19 H2160325X;
label value GVCJU19 H2160326X;
label value GVCMA19 H2160327X;
label value GVCMY19 H2160328X;
label value GVCNO19 H2160329X;
label value GVCOC19 H2160330X;
label value GVCSE19 H2160331X;
label value HASFSA31 H2160332X;
label value HAVEUS42 H2160333X;
label value HAVFUN42 H2160334X;
label value HELD31X H2160335X;
label value HELD42X H2160336X;
label value HELD53X H2160337X;
label value HHAGD19 H2160338X;
label value HHINDD19 H2160339X;
label value HHINFD19 H2160340X;
label value HHTOTD19 H2160341X;
label value HIBPAGED H2160342X;
label value HIBPDX H2160343X;
label value HIDEG H2160344X;
label value HISPANX H2160345X;
label value HISPNCAT H2160346X;
label value HOMEBH42 H2160347X;
label value HOUR31 H2160348X;
label value HOUR42 H2160349X;
label value HOUR53 H2160350X;
label value HPDAP19 H2160351X;
label value HPDAU19 H2160352X;
label value HPDDE19 H2160353X;
label value HPDFE19 H2160354X;
label value HPDJA19 H2160355X;
label value HPDJL19 H2160356X;
label value HPDJU19 H2160357X;
label value HPDMA19 H2160358X;
label value HPDMY19 H2160359X;
label value HPDNO19 H2160360X;
label value HPDOC19 H2160361X;
label value HPDSE19 H2160362X;
label value HPEAP19 H2160363X;
label value HPEAU19 H2160364X;
label value HPEDE19 H2160365X;
label value HPEFE19 H2160366X;
label value HPEJA19 H2160367X;
label value HPEJL19 H2160368X;
label value HPEJU19 H2160369X;
label value HPEMA19 H2160370X;
label value HPEMY19 H2160371X;
label value HPENO19 H2160372X;
label value HPEOC19 H2160373X;
label value HPESE19 H2160374X;
label value HPNAP19 H2160375X;
label value HPNAU19 H2160376X;
label value HPNDE19 H2160377X;
label value HPNFE19 H2160378X;
label value HPNJA19 H2160379X;
label value HPNJL19 H2160380X;
label value HPNJU19 H2160381X;
label value HPNMA19 H2160382X;
label value HPNMY19 H2160383X;
label value HPNNO19 H2160384X;
label value HPNOC19 H2160385X;
label value HPNSE19 H2160386X;
label value HPOAP19 H2160387X;
label value HPOAU19 H2160388X;
label value HPODE19 H2160389X;
label value HPOFE19 H2160390X;
label value HPOJA19 H2160391X;
label value HPOJL19 H2160392X;
label value HPOJU19 H2160393X;
label value HPOMA19 H2160394X;
label value HPOMY19 H2160395X;
label value HPONO19 H2160396X;
label value HPOOC19 H2160397X;
label value HPOSE19 H2160398X;
label value HPRAP19 H2160399X;
label value HPRAU19 H2160400X;
label value HPRDE19 H2160401X;
label value HPRFE19 H2160402X;
label value HPRJA19 H2160403X;
label value HPRJL19 H2160404X;
label value HPRJU19 H2160405X;
label value HPRMA19 H2160406X;
label value HPRMY19 H2160407X;
label value HPRNO19 H2160408X;
label value HPROC19 H2160409X;
label value HPRSE19 H2160410X;
label value HPXAP19 H2160411X;
label value HPXAU19 H2160412X;
label value HPXDE19 H2160413X;
label value HPXFE19 H2160414X;
label value HPXJA19 H2160415X;
label value HPXJL19 H2160416X;
label value HPXJU19 H2160417X;
label value HPXMA19 H2160418X;
label value HPXMY19 H2160419X;
label value HPXNO19 H2160420X;
label value HPXOC19 H2160421X;
label value HPXSE19 H2160422X;
label value HRHOW31 H2160423X;
label value HRHOW42 H2160424X;
label value HRHOW53 H2160425X;
label value HRWG31H H2160426X;
label value HRWG31X H2160427X;
label value HRWG42H H2160428X;
label value HRWG42X H2160429X;
label value HRWG53H H2160430X;
label value HRWG53X H2160431X;
label value HRWGIM31 H2160432X;
label value HRWGIM42 H2160433X;
label value HRWGIM53 H2160434X;
label value HSELIM31 H2160435X;
label value HSPLAP42 H2160436X;
label value HWELLSPK H2160437X;
label value IADLHP31 H2160438X;
label value IHS19 H2160439X;
label value IHS31 H2160440X;
label value IHS42 H2160441X;
label value IHS53 H2160442X;
label value IHSAP19 H2160443X;
label value IHSAT19 H2160444X;
label value IHSAT31 H2160445X;
label value IHSAT42 H2160446X;
label value IHSAT53 H2160447X;
label value IHSAU19 H2160448X;
label value IHSDE19 H2160449X;
label value IHSFE19 H2160450X;
label value IHSJA19 H2160451X;
label value IHSJL19 H2160452X;
label value IHSJU19 H2160453X;
label value IHSMA19 H2160454X;
label value IHSMY19 H2160455X;
label value IHSNO19 H2160456X;
label value IHSOC19 H2160457X;
label value IHSSE19 H2160458X;
label value INDCAT31 H2160459X;
label value INDCAT42 H2160460X;
label value INDCAT53 H2160461X;
label value INDCT31H H2160462X;
label value INDCT42H H2160463X;
label value INDCT53H H2160464X;
label value INS19X H2160465X;
label value INS31X H2160466X;
label value INS42X H2160467X;
label value INS53X H2160468X;
label value INSAP19X H2160469X;
label value INSAT19X H2160470X;
label value INSAT31X H2160471X;
label value INSAT42X H2160472X;
label value INSAT53X H2160473X;
label value INSAU19X H2160474X;
label value INSC1231 H2160475X;
label value INSCOP19 H2160476X;
label value INSCOP31 H2160477X;
label value INSCOP42 H2160478X;
label value INSCOP53 H2160479X;
label value INSCOPE H2160480X;
label value INSCOV19 H2160481X;
label value INSDE19X H2160482X;
label value INSFE19X H2160483X;
label value INSJA19X H2160484X;
label value INSJL19X H2160485X;
label value INSJU19X H2160486X;
label value INSMA19X H2160487X;
label value INSMY19X H2160488X;
label value INSNO19X H2160489X;
label value INSOC19X H2160490X;
label value INSSE19X H2160491X;
label value INSURC19 H2160492X;
label value INTIMP19 H2160493X;
label value INTVLANG H2160494X;
label value IPDIS19 H2160495X;
label value IPNGTD19 H2160496X;
label value IRAIMP19 H2160497X;
label value JBORG31H H2160498X;
label value JBORG42H H2160499X;
label value JBORG53H H2160500X;
label value JNTPID19 H2160501X;
label value JOBORG31 H2160502X;
label value JOBORG42 H2160503X;
label value JOBORG53 H2160504X;
label value JTINRU19 H2160505X;
label value JTPAIN31_M18 H2160506X;
label value K6SUM42 H2160507X;
label value KEYNESS H2160508X;
label value KIDPRO42 H2160509X;
label value LFTDIF31 H2160510X;
label value LOCATN42 H2160511X;
label value LSTETH53 H2160512X;
label value MARRY19X H2160513X;
label value MARRY31X H2160514X;
label value MARRY42X H2160515X;
label value MARRY53X H2160516X;
label value MCAID19 H2160517X;
label value MCAID19X H2160518X;
label value MCAID31 H2160519X;
label value MCAID31X H2160520X;
label value MCAID42 H2160521X;
label value MCAID42X H2160522X;
label value MCAID53 H2160523X;
label value MCAID53X H2160524X;
label value MCARE19 H2160525X;
label value MCARE19X H2160526X;
label value MCARE31 H2160527X;
label value MCARE31X H2160528X;
label value MCARE42 H2160529X;
label value MCARE42X H2160530X;
label value MCARE53 H2160531X;
label value MCARE53X H2160532X;
label value MCDAP19 H2160533X;
label value MCDAP19X H2160534X;
label value MCDAT19X H2160535X;
label value MCDAT31X H2160536X;
label value MCDAT42X H2160537X;
label value MCDAT53X H2160538X;
label value MCDAU19 H2160539X;
label value MCDAU19X H2160540X;
label value MCDDE19 H2160541X;
label value MCDDE19X H2160542X;
label value MCDEV19 H2160543X;
label value MCDFE19 H2160544X;
label value MCDFE19X H2160545X;
label value MCDHMO19 H2160546X;
label value MCDHMO31 H2160547X;
label value MCDHMO42 H2160548X;
label value MCDJA19 H2160549X;
label value MCDJA19X H2160550X;
label value MCDJL19 H2160551X;
label value MCDJL19X H2160552X;
label value MCDJU19 H2160553X;
label value MCDJU19X H2160554X;
label value MCDMA19 H2160555X;
label value MCDMA19X H2160556X;
label value MCDMC19 H2160557X;
label value MCDMC31 H2160558X;
label value MCDMC42 H2160559X;
label value MCDMY19 H2160560X;
label value MCDMY19X H2160561X;
label value MCDNO19 H2160562X;
label value MCDNO19X H2160563X;
label value MCDOC19 H2160564X;
label value MCDOC19X H2160565X;
label value MCDSE19 H2160566X;
label value MCDSE19X H2160567X;
label value MCRAP19 H2160568X;
label value MCRAP19X H2160569X;
label value MCRAU19 H2160570X;
label value MCRAU19X H2160571X;
label value MCRDE19 H2160572X;
label value MCRDE19X H2160573X;
label value MCREV19 H2160574X;
label value MCRFE19 H2160575X;
label value MCRFE19X H2160576X;
label value MCRJA19 H2160577X;
label value MCRJA19X H2160578X;
label value MCRJL19 H2160579X;
label value MCRJL19X H2160580X;
label value MCRJU19 H2160581X;
label value MCRJU19X H2160582X;
label value MCRMA19 H2160583X;
label value MCRMA19X H2160584X;
label value MCRMY19 H2160585X;
label value MCRMY19X H2160586X;
label value MCRNO19 H2160587X;
label value MCRNO19X H2160588X;
label value MCROC19 H2160589X;
label value MCROC19X H2160590X;
label value MCRPB19 H2160591X;
label value MCRPB31 H2160592X;
label value MCRPB42 H2160593X;
label value MCRPD19 H2160594X;
label value MCRPD19X H2160595X;
label value MCRPD31 H2160596X;
label value MCRPD31X H2160597X;
label value MCRPD42 H2160598X;
label value MCRPD42X H2160599X;
label value MCRPHO19 H2160600X;
label value MCRPHO31 H2160601X;
label value MCRPHO42 H2160602X;
label value MCRSE19 H2160603X;
label value MCRSE19X H2160604X;
label value MIAGED H2160605X;
label value MIDX H2160606X;
label value MILDIF31 H2160607X;
label value MNHLTH31 H2160608X;
label value MNHLTH42 H2160609X;
label value MNHLTH53 H2160610X;
label value MOMPRO42 H2160611X;
label value MORE31 H2160612X;
label value MORE31H H2160613X;
label value MORE42 H2160614X;
label value MORE42H H2160615X;
label value MORE53 H2160616X;
label value MORE53H H2160617X;
label value MORECOVR H2160618X;
label value MORJOB31 H2160619X;
label value MORJOB42 H2160620X;
label value MORJOB53 H2160621X;
label value NATAMP42 H2160622X;
label value NERVAF42 H2160623X;
label value NHRWG31 H2160624X;
label value NHRWG42 H2160625X;
label value NHRWG53 H2160626X;
label value NUMEMP31 H2160627X;
label value NUMEMP42 H2160628X;
label value NUMEMP53 H2160629X;
label value NWK31 H2160630X;
label value NWK42 H2160631X;
label value NWK53 H2160632X;
label value OBDRV19 H2160633X;
label value OBTOTV19 H2160634X;
label value OCCCAT31 H2160635X;
label value OCCCAT42 H2160636X;
label value OCCCAT53 H2160637X;
label value OCCCT31H H2160638X;
label value OCCCT42H H2160639X;
label value OCCCT53H H2160640X;
label value OFEMP31H H2160641X;
label value OFEMP42H H2160642X;
label value OFEMP53H H2160643X;
label value OFFER31H H2160644X;
label value OFFER31X H2160645X;
label value OFFER42H H2160646X;
label value OFFER42X H2160647X;
label value OFFER53H H2160648X;
label value OFFER53X H2160649X;
label value OFFHOU42 H2160650X;
label value OFREMP31 H2160651X;
label value OFREMP42 H2160652X;
label value OFREMP53 H2160653X;
label value OFTSMK53 H2160654X;
label value OHRTAGED H2160655X;
label value OHRTDX H2160656X;
label value OHRTTYPE H2160657X;
label value OPDRV19 H2160658X;
label value OPTOTV19 H2160659X;
label value OTHDYS19 H2160660X;
label value OTHIMP19 H2160661X;
label value OTHLGSPK H2160662X;
label value OTHNDD19 H2160663X;
label value OTHRCP42 H2160664X;
label value PACISP42 H2160665X;
label value PANEL H2160666X;
label value PAYDR31 H2160667X;
label value PAYDR31H H2160668X;
label value PAYDR42 H2160669X;
label value PAYDR42H H2160670X;
label value PAYDR53 H2160671X;
label value PAYDR53H H2160672X;
label value PAYVAC31 H2160673X;
label value PAYVAC42 H2160674X;
label value PAYVAC53 H2160675X;
label value PDKAP19 H2160676X;
label value PDKAU19 H2160677X;
label value PDKDE19 H2160678X;
label value PDKFE19 H2160679X;
label value PDKJA19 H2160680X;
label value PDKJL19 H2160681X;
label value PDKJU19 H2160682X;
label value PDKMA19 H2160683X;
label value PDKMY19 H2160684X;
label value PDKNO19 H2160685X;
label value PDKOC19 H2160686X;
label value PDKSE19 H2160687X;
label value PEGAP19 H2160688X;
label value PEGAU19 H2160689X;
label value PEGDE19 H2160690X;
label value PEGFE19 H2160691X;
label value PEGJA19 H2160692X;
label value PEGJL19 H2160693X;
label value PEGJU19 H2160694X;
label value PEGMA19 H2160695X;
label value PEGMY19 H2160696X;
label value PEGNO19 H2160697X;
label value PEGOC19 H2160698X;
label value PEGSE19 H2160699X;
label value PENIMP19 H2160700X;
label value PFSAMT31 H2160701X;
label value PHNREG42 H2160702X;
label value PHQ242 H2160703X;
label value PHYEXE53 H2160704X;
label value PLCTYP42 H2160705X;
label value PMDINS19 H2160706X;
label value PMDINS31 H2160707X;
label value PMEDIN31 H2160708X;
label value PMEDIN42 H2160709X;
label value PMEDIN53 H2160710X;
label value PMEDPY31 H2160711X;
label value PMEDPY42 H2160712X;
label value PMEDPY53 H2160713X;
label value PMEDUP31 H2160714X;
label value PMEDUP42 H2160715X;
label value PMEDUP53 H2160716X;
label value PNEAP19 H2160717X;
label value PNEAU19 H2160718X;
label value PNEDE19 H2160719X;
label value PNEFE19 H2160720X;
label value PNEJA19 H2160721X;
label value PNEJL19 H2160722X;
label value PNEJU19 H2160723X;
label value PNEMA19 H2160724X;
label value PNEMY19 H2160725X;
label value PNENO19 H2160726X;
label value PNEOC19 H2160727X;
label value PNESE19 H2160728X;
label value PNGAP19 H2160729X;
label value PNGAU19 H2160730X;
label value PNGDE19 H2160731X;
label value PNGFE19 H2160732X;
label value PNGJA19 H2160733X;
label value PNGJL19 H2160734X;
label value PNGJU19 H2160735X;
label value PNGMA19 H2160736X;
label value PNGMY19 H2160737X;
label value PNGNO19 H2160738X;
label value PNGOC19 H2160739X;
label value PNGSE19 H2160740X;
label value POEAP19 H2160741X;
label value POEAU19 H2160742X;
label value POEDE19 H2160743X;
label value POEFE19 H2160744X;
label value POEJA19 H2160745X;
label value POEJL19 H2160746X;
label value POEJU19 H2160747X;
label value POEMA19 H2160748X;
label value POEMY19 H2160749X;
label value POENO19 H2160750X;
label value POEOC19 H2160751X;
label value POESE19 H2160752X;
label value POGAP19 H2160753X;
label value POGAU19 H2160754X;
label value POGDE19 H2160755X;
label value POGFE19 H2160756X;
label value POGJA19 H2160757X;
label value POGJL19 H2160758X;
label value POGJU19 H2160759X;
label value POGMA19 H2160760X;
label value POGMY19 H2160761X;
label value POGNO19 H2160762X;
label value POGOC19 H2160763X;
label value POGSE19 H2160764X;
label value POVCAT19 H2160765X;
label value PRACTP42 H2160766X;
label value PREVCOVR H2160767X;
label value PRIAP19 H2160768X;
label value PRIAU19 H2160769X;
label value PRIDE19 H2160770X;
label value PRIDK19 H2160771X;
label value PRIDK31 H2160772X;
label value PRIDK42 H2160773X;
label value PRIDK53 H2160774X;
label value PRIEU19 H2160775X;
label value PRIEU31 H2160776X;
label value PRIEU42 H2160777X;
label value PRIEU53 H2160778X;
label value PRIEUO19 H2160779X;
label value PRIEUO31 H2160780X;
label value PRIEUO42 H2160781X;
label value PRIEUO53 H2160782X;
label value PRIFE19 H2160783X;
label value PRIJA19 H2160784X;
label value PRIJL19 H2160785X;
label value PRIJU19 H2160786X;
label value PRIMA19 H2160787X;
label value PRIMY19 H2160788X;
label value PRINEO19 H2160789X;
label value PRINEO31 H2160790X;
label value PRINEO42 H2160791X;
label value PRINEO53 H2160792X;
label value PRING19 H2160793X;
label value PRING31 H2160794X;
label value PRING42 H2160795X;
label value PRING53 H2160796X;
label value PRINO19 H2160797X;
label value PRIOC19 H2160798X;
label value PRIOG19 H2160799X;
label value PRIOG31 H2160800X;
label value PRIOG42 H2160801X;
label value PRIOG53 H2160802X;
label value PRISE19 H2160803X;
label value PRIV19 H2160804X;
label value PRIV31 H2160805X;
label value PRIV42 H2160806X;
label value PRIV53 H2160807X;
label value PRIVAT19 H2160808X;
label value PRIVAT31 H2160809X;
label value PRIVAT42 H2160810X;
label value PRIVAT53 H2160811X;
label value PROBPY42 H2160812X;
label value PROVTY42_M18 H2160813X;
label value PROXY19 H2160814X;
label value PROXY31 H2160815X;
label value PROXY42 H2160816X;
label value PROXY53 H2160817X;
label value PRSTX19 H2160818X;
label value PRSTX31 H2160819X;
label value PRSTX42 H2160820X;
label value PRSTX53 H2160821X;
label value PRVEV19 H2160822X;
label value PRVHMO19 H2160823X;
label value PRVHMO31 H2160824X;
label value PRVHMO42 H2160825X;
label value PRVSPK42 H2160826X;
label value PRXAP19 H2160827X;
label value PRXAU19 H2160828X;
label value PRXDE19 H2160829X;
label value PRXFE19 H2160830X;
label value PRXJA19 H2160831X;
label value PRXJL19 H2160832X;
label value PRXJU19 H2160833X;
label value PRXMA19 H2160834X;
label value PRXMY19 H2160835X;
label value PRXNO19 H2160836X;
label value PRXOC19 H2160837X;
label value PRXSE19 H2160838X;
label value PSTATS31 H2160839X;
label value PSTATS42 H2160840X;
label value PSTATS53 H2160841X;
label value PUB19X H2160842X;
label value PUB31X H2160843X;
label value PUB42X H2160844X;
label value PUB53X H2160845X;
label value PUBAP19X H2160846X;
label value PUBAT19X H2160847X;
label value PUBAT31X H2160848X;
label value PUBAT42X H2160849X;
label value PUBAT53X H2160850X;
label value PUBAU19X H2160851X;
label value PUBDE19X H2160852X;
label value PUBFE19X H2160853X;
label value PUBIMP19 H2160854X;
label value PUBJA19X H2160855X;
label value PUBJL19X H2160856X;
label value PUBJU19X H2160857X;
label value PUBMA19X H2160858X;
label value PUBMY19X H2160859X;
label value PUBNO19X H2160860X;
label value PUBOC19X H2160861X;
label value PUBSE19X H2160862X;
label value PYUNBL42 H2160863X;
label value PYVAC31H H2160864X;
label value PYVAC42H H2160865X;
label value PYVAC53H H2160866X;
label value RACEAX H2160867X;
label value RACEBX H2160868X;
label value RACETHX H2160869X;
label value RACEV1X H2160870X;
label value RACEV2X H2160871X;
label value RACEWX H2160872X;
label value RCHDIF31 H2160873X;
label value REFRL19X H2160874X;
label value REFRL31X H2160875X;
label value REFRL42X H2160876X;
label value REFRL53X H2160877X;
label value REGION19 H2160878X;
label value REGION31 H2160879X;
label value REGION42 H2160880X;
label value REGION53 H2160881X;
label value RESP19 H2160882X;
label value RESP31 H2160883X;
label value RESP42 H2160884X;
label value RESP53 H2160885X;
label value RETPLN31 H2160886X;
label value RETPLN42 H2160887X;
label value RETPLN53 H2160888X;
label value RNDFLG31 H2160889X;
label value RTHLTH31 H2160890X;
label value RTHLTH42 H2160891X;
label value RTHLTH53 H2160892X;
label value RTPLN31H H2160893X;
label value RTPLN42H H2160894X;
label value RTPLN53H H2160895X;
label value RUCLAS19 H2160896X;
label value RUCLAS31 H2160897X;
label value RUCLAS42 H2160898X;
label value RUCLAS53 H2160899X;
label value RUSIZE19 H2160900X;
label value RUSIZE31 H2160901X;
label value RUSIZE42 H2160902X;
label value RUSIZE53 H2160903X;
label value SALIMP19 H2160904X;
label value SAQELIG H2160905X;
label value SCHLBH42 H2160906X;
label value SCHLIM31 H2160907X;
label value SCHPRO42 H2160908X;
label value SCPAY31H H2160909X;
label value SCPAY42H H2160910X;
label value SCPAY53H H2160911X;
label value SELFCM31 H2160912X;
label value SELFCM42 H2160913X;
label value SELFCM53 H2160914X;
label value SEX H2160915X;
label value SIBPRO42 H2160916X;
label value SICPAY31 H2160917X;
label value SICPAY42 H2160918X;
label value SICPAY53 H2160919X;
label value SLFCM31H H2160920X;
label value SLFCM42H H2160921X;
label value SLFCM53H H2160922X;
label value SOCLIM31 H2160923X;
label value SPOUID19 H2160924X;
label value SPOUID31 H2160925X;
label value SPOUID42 H2160926X;
label value SPOUID53 H2160927X;
label value SPOUIN19 H2160928X;
label value SPOUIN31 H2160929X;
label value SPOUIN42 H2160930X;
label value SPOUIN53 H2160931X;
label value SPRPRO42 H2160932X;
label value SSCIMP19 H2160933X;
label value SSIIMP19 H2160934X;
label value SSNLJB31 H2160935X;
label value SSNLJB42 H2160936X;
label value SSNLJB53 H2160937X;
label value STJBMM31 H2160938X;
label value STJBMM42 H2160939X;
label value STJBMM53 H2160940X;
label value STJBYY31 H2160941X;
label value STJBYY42 H2160942X;
label value STJBYY53 H2160943X;
label value STNDIF31 H2160944X;
label value STPDIF31 H2160945X;
label value STRKAGED H2160946X;
label value STRKDX H2160947X;
label value TAXFRM19 H2160948X;
label value TEMPJB31 H2160949X;
label value TEMPJB42 H2160950X;
label value TEMPJB53 H2160951X;
label value TMTKUS42 H2160952X;
label value TREATM42 H2160953X;
label value TRIAP19X H2160954X;
label value TRIAT19X H2160955X;
label value TRIAT31X H2160956X;
label value TRIAT42X H2160957X;
label value TRIAT53X H2160958X;
label value TRIAU19X H2160959X;
label value TRICH19X H2160960X;
label value TRICH31X H2160961X;
label value TRICH42X H2160962X;
label value TRICR19X H2160963X;
label value TRICR31X H2160964X;
label value TRICR42X H2160965X;
label value TRICR53X H2160966X;
label value TRIDE19X H2160967X;
label value TRIEV19 H2160968X;
label value TRIEX19X H2160969X;
label value TRIEX31X H2160970X;
label value TRIEX42X H2160971X;
label value TRIFE19X H2160972X;
label value TRIJA19X H2160973X;
label value TRIJL19X H2160974X;
label value TRIJU19X H2160975X;
label value TRILI19X H2160976X;
label value TRILI31X H2160977X;
label value TRILI42X H2160978X;
label value TRIMA19X H2160979X;
label value TRIMY19X H2160980X;
label value TRINO19X H2160981X;
label value TRIOC19X H2160982X;
label value TRIPR19X H2160983X;
label value TRIPR31X H2160984X;
label value TRIPR42X H2160985X;
label value TRISE19X H2160986X;
label value TRIST19X H2160987X;
label value TRIST31X H2160988X;
label value TRIST42X H2160989X;
label value TRTIMP19 H2160990X;
label value TYPEPE42 H2160991X;
label value UNABLE31 H2160992X;
label value UNEIMP19 H2160993X;
label value UNHAP42 H2160994X;
label value UNINS19 H2160995X;
label value UNION31 H2160996X;
label value UNION31H H2160997X;
label value UNION42 H2160998X;
label value UNION42H H2160999X;
label value UNION53 H2161000X;
label value UNION53H H2161001X;
label value VABACK31 H2161002X;
label value VABIPL31 H2161003X;
label value VACARC31 H2161004X;
label value VACARE31 H2161005X;
label value VACMPM31 H2161006X;
label value VACMPY31 H2161007X;
label value VACOMP31 H2161008X;
label value VACOPD31 H2161009X;
label value VACOST31 H2161010X;
label value VACRGV31 H2161011X;
label value VACTDY31 H2161012X;
label value VADEPR31 H2161013X;
label value VADERM31 H2161014X;
label value VAEV19 H2161015X;
label value VAFIBR31 H2161016X;
label value VAGCNS31 H2161017X;
label value VAGERD31 H2161018X;
label value VAGOUT31 H2161019X;
label value VAGTRC31 H2161020X;
label value VAHRLS31 H2161021X;
label value VAJTPN31 H2161022X;
label value VALCOH31 H2161023X;
label value VALOCT31 H2161024X;
label value VAMNHC31 H2161025X;
label value VAMOBL31 H2161026X;
label value VAMOOD31 H2161027X;
label value VAMREC31 H2161028X;
label value VANECK31 H2161029X;
label value VANEED31 H2161030X;
label value VANTWK31 H2161031X;
label value VAOUT31 H2161032X;
label value VAPACT31 H2161033X;
label value VAPAP19 H2161034X;
label value VAPAST31 H2161035X;
label value VAPAU19 H2161036X;
label value VAPCCO31 H2161037X;
label value VAPCOT31 H2161038X;
label value VAPCOU31 H2161039X;
label value VAPCPR31 H2161040X;
label value VAPCRC31 H2161041X;
label value VAPCRF31 H2161042X;
label value VAPCSN31 H2161043X;
label value VAPCSO31 H2161044X;
label value VAPCUN31 H2161045X;
label value VAPDE19 H2161046X;
label value VAPFE19 H2161047X;
label value VAPJA19 H2161048X;
label value VAPJL19 H2161049X;
label value VAPJU19 H2161050X;
label value VAPMA19 H2161051X;
label value VAPMY19 H2161052X;
label value VAPNO19 H2161053X;
label value VAPOC19 H2161054X;
label value VAPRAT19 H2161055X;
label value VAPRAT31 H2161056X;
label value VAPRAT42 H2161057X;
label value VAPRAT53 H2161058X;
label value VAPRHT31 H2161059X;
label value VAPROB31 H2161060X;
label value VAPROG19 H2161061X;
label value VAPROG31 H2161062X;
label value VAPROG42 H2161063X;
label value VAPROG53 H2161064X;
label value VAPROS31 H2161065X;
label value VAPROV31 H2161066X;
label value VAPROX31 H2161067X;
label value VAPSE19 H2161068X;
label value VAPTSD31 H2161069X;
label value VARECM31 H2161070X;
label value VAREP31 H2161071X;
label value VARHAB31 H2161072X;
label value VARTHR31 H2161073X;
label value VARXMD31 H2161074X;
label value VASPCL31 H2161075X;
label value VASPMH31 H2161076X;
label value VASPOU31 H2161077X;
label value VASPUN31 H2161078X;
label value VATMD31 H2161079X;
label value VAWAIT31 H2161080X;
label value VERFLG19 H2161081X;
label value VERFLG31 H2161082X;
label value VERFLG42 H2161083X;
label value VETIMP19 H2161084X;
label value VMCS42 H2161085X;
label value VPCS42 H2161086X;
label value VRFLAG42 H2161087X;
label value VSAQELIG H2161088X;
label value WAGIMP19 H2161089X;
label value WCPIMP19 H2161090X;
label value WHITPR42 H2161091X;
label value WHTLGSPK H2161092X;
label value WILFIL19 H2161093X;
label value WLKDIF31 H2161094X;
label value WLKLIM31 H2161095X;
label value WRKLIM31 H2161096X;
label value YCHJ3142 H2161097X;
label value YCHJ4253 H2161098X;
label value YNOUSC42_M18 H2161099X;
label value YRSINUS H2161100X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;

#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H216.LOG and a data file named H216.DTA.  If these files (H216.DTA and H216.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

